"use strict";
(self["webpackChunkphotos"] = self["webpackChunkphotos"] || []).push([["src_mixins_FilesSelectionMixin_js-src_components_File_vue-src_components_FilesListViewer_vue"],{

/***/ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/File.vue?vue&type=script&lang=js&":
/*!**************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/File.vue?vue&type=script&lang=js& ***!
  \**************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue_material_design_icons_Star_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-material-design-icons/Star.vue */ "./node_modules/vue-material-design-icons/Star.vue");
/* harmony import */ var vue_material_design_icons_Video_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue-material-design-icons/Video.vue */ "./node_modules/vue-material-design-icons/Video.vue");
/* harmony import */ var _nextcloud_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @nextcloud/router */ "./node_modules/@nextcloud/router/dist/index.js");
/* harmony import */ var _nextcloud_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @nextcloud/vue */ "./node_modules/@nextcloud/vue/dist/index.module.js");
/* harmony import */ var _utils_semaphoreWithPriority_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/semaphoreWithPriority.js */ "./src/utils/semaphoreWithPriority.js");
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//






/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'File',
  components: {
    NcCheckboxRadioSwitch: _nextcloud_vue__WEBPACK_IMPORTED_MODULE_3__.NcCheckboxRadioSwitch,
    Star: vue_material_design_icons_Star_vue__WEBPACK_IMPORTED_MODULE_0__["default"],
    VideoIcon: vue_material_design_icons_Video_vue__WEBPACK_IMPORTED_MODULE_1__["default"]
  },
  inheritAttrs: false,
  props: {
    file: {
      type: Object,
      required: true
    },
    selected: {
      type: Boolean,
      required: true
    },
    allowSelection: {
      type: Boolean,
      default: true
    },
    visibility: {
      type: String,
      required: true
    },
    semaphore: {
      type: _utils_semaphoreWithPriority_js__WEBPACK_IMPORTED_MODULE_4__["default"],
      required: true
    }
  },
  data() {
    return {
      loadedNear: false,
      loadedVisible: false,
      errorNear: false,
      errorVisible: false,
      canLoad: false,
      semaphoreSymbol: null,
      isDestroyed: false
    };
  },
  computed: {
    /** @return {string} */
    ariaDescription() {
      return `image-description-${this.file.fileid}`;
    },
    /** @return {string} */
    ariaLabel() {
      return t('photos', 'Open the full size "{name}" image', {
        name: this.file.basename
      });
    },
    /** @return {boolean} */
    isImage() {
      return this.file.mime.startsWith('image');
    },
    /** @return {string} */
    decodedEtag() {
      return this.file.etag.replace('&quot;', '').replace('&quot;', '');
    },
    /** @return {string} */
    srcVisible() {
      return this.getItemURL(512);
    },
    /** @return {string} */
    srcNear() {
      return this.getItemURL(64);
    }
  },
  async mounted() {
    this.semaphoreSymbol = await this.semaphore.acquire(() => {
      switch (this.visibility) {
        case 'visible':
          return 1;
        case 'near':
          return 2;
        default:
          return 3;
      }
    }, this.file.fileid);
    if (this.visibility === 'none' || this.isDestroyed) {
      this.releaseSemaphore();
      return;
    }
    this.canLoad = true;
  },
  beforeDestroy() {
    this.isDestroyed = true;
    this.releaseSemaphore();

    // cancel any pending load
    if (this.$refs.imgNear !== undefined) {
      this.$refs.imgNear.src = '';
    }
    if (this.$refs.srcVisible !== undefined) {
      this.$refs.srcVisible.src = '';
    }
  },
  methods: {
    emitClick() {
      this.$emit('click', this.file.fileid);
    },
    /** When the 'near' image is fully loaded by browser we release semaphore */
    onLoadNear() {
      this.loadedNear = true;
      this.releaseSemaphore();
    },
    /** When the 'visible' image is fully loaded by browser we release semaphore */
    onLoadVisible() {
      this.loadedVisible = true;
      this.releaseSemaphore();
    },
    onErrorNear() {
      this.errorNear = true;
      this.releaseSemaphore();
    },
    onErrorVisible() {
      this.errorVisible = true;
      this.releaseSemaphore();
    },
    onToggle(value) {
      this.$emit('select-toggled', {
        id: this.file.fileid,
        value
      });
    },
    getItemURL(size) {
      const token = this.$route.params.token;
      if (token) {
        return (0,_nextcloud_router__WEBPACK_IMPORTED_MODULE_2__.generateUrl)(`/apps/photos/api/v1/publicPreview/${this.file.fileid}?etag=${this.decodedEtag}&x=${size}&y=${size}&token=${token}`);
      } else {
        return (0,_nextcloud_router__WEBPACK_IMPORTED_MODULE_2__.generateUrl)(`/apps/photos/api/v1/preview/${this.file.fileid}?etag=${this.decodedEtag}&x=${size}&y=${size}`);
      }
    },
    releaseSemaphore() {
      if (this.semaphoreSymbol === null) {
        return;
      }
      this.semaphore.release(this.semaphoreSymbol);
      this.semaphoreSymbol = null;
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/FilesListViewer.vue?vue&type=script&lang=js&":
/*!*************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/FilesListViewer.vue?vue&type=script&lang=js& ***!
  \*************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm.js");
/* harmony import */ var vue_material_design_icons_PackageVariant_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-material-design-icons/PackageVariant.vue */ "./node_modules/vue-material-design-icons/PackageVariant.vue");
/* harmony import */ var _nextcloud_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @nextcloud/vue */ "./node_modules/@nextcloud/vue/dist/index.module.js");
/* harmony import */ var _nextcloud_event_bus__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @nextcloud/event-bus */ "./node_modules/@nextcloud/event-bus/dist/index.mjs");
/* harmony import */ var _components_TiledLayout_TiledLayout_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../components/TiledLayout/TiledLayout.vue */ "./src/components/TiledLayout/TiledLayout.vue");
/* harmony import */ var _services_fileFetcher_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../services/fileFetcher.js */ "./src/services/fileFetcher.js");
/* harmony import */ var _components_VirtualScrolling_vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../components/VirtualScrolling.vue */ "./src/components/VirtualScrolling.vue");
/* harmony import */ var _assets_Illustrations_empty_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../assets/Illustrations/empty.svg */ "./src/assets/Illustrations/empty.svg");
/* harmony import */ var _mixins_UserConfig_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../mixins/UserConfig.js */ "./src/mixins/UserConfig.js");
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//










/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'FilesListViewer',
  components: {
    PackageVariant: vue_material_design_icons_PackageVariant_vue__WEBPACK_IMPORTED_MODULE_0__["default"],
    NcEmptyContent: _nextcloud_vue__WEBPACK_IMPORTED_MODULE_1__.NcEmptyContent,
    NcLoadingIcon: _nextcloud_vue__WEBPACK_IMPORTED_MODULE_1__.NcLoadingIcon,
    TiledLayout: _components_TiledLayout_TiledLayout_vue__WEBPACK_IMPORTED_MODULE_3__["default"],
    VirtualScrolling: _components_VirtualScrolling_vue__WEBPACK_IMPORTED_MODULE_5__["default"]
  },
  mixins: [_mixins_UserConfig_js__WEBPACK_IMPORTED_MODULE_7__["default"]],
  props: {
    // Array of file ids that should be rendered.
    fileIds: {
      type: Array,
      default: undefined
    },
    // An object mapping a list of section to a list of fileIds.
    fileIdsBySection: {
      type: Object,
      default: undefined
    },
    // The list of sorted sections.
    sections: {
      type: Array,
      default: undefined
    },
    // Whether we should display a loading indicator.
    loading: {
      type: Boolean,
      default: false
    },
    // Message to display when there is no files.
    emptyMessage: {
      type: String,
      default: ''
    },
    // The base height to forward to TileLayout.
    baseHeight: {
      type: Number,
      default: 200
    },
    // The height to use for section headers.
    sectionHeaderHeight: {
      type: Number,
      default: 75
    },
    // Instruct VirtualScrolling to scroll to the given section id.
    scrollToSection: {
      type: String,
      default: ''
    },
    // The containerElement props to forward to TileLayout.
    containerElement: {
      type: HTMLElement,
      default: null
    },
    // The useWindow props to forward to TileLayout.
    useWindow: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      EmptyBox: _assets_Illustrations_empty_svg__WEBPACK_IMPORTED_MODULE_6__,
      placeholderFiles: Array(20).fill(0).map((_, index) => {
        const height = 200;
        const width = this.croppedLayout ? height : height * (1 + Math.random() * 2);
        return {
          id: index,
          width,
          height,
          ratio: width / height
        };
      })
    };
  },
  computed: {
    ...(0,vuex__WEBPACK_IMPORTED_MODULE_8__.mapGetters)(['files']),
    /**
     * @return {object[]} The list of items to pass to TiledLayout.
     */
    fileIdsToItems() {
      if (this.fileIds === undefined) {
        return [];
      }
      return this.fileIds.filter(fileId => this.files[fileId]).map(this.mapFileToItem);
    },
    /**
     * @return {object[]} The list of items separated by sections to pass to TiledLayout.
     */
    sectionsToItems() {
      if (this.sections === undefined) {
        return [];
      }
      return this.sections.flatMap(sectionId => {
        return [{
          id: sectionId,
          sectionHeader: true,
          height: this.sectionHeaderHeight
        }, ...this.fileIdsBySection[sectionId].filter(fileId => this.files[fileId]).map(this.mapFileToItem)];
      });
    },
    /**
     * @return {boolean} The list of items to pass to TiledLayout.
     */
    showPlaceholders() {
      return this.loading && (this.fileIds?.length === 0 || this.sections?.length === 0);
    },
    /**
     * @return {object[]} The list of items to pass to TiledLayout.
     */
    items() {
      if (this.fileIds !== undefined) {
        if (this.showPlaceholders) {
          return this.placeholderFiles;
        }
        return this.fileIdsToItems;
      }
      if (this.sections !== undefined) {
        if (this.showPlaceholders) {
          return [{
            height: 75,
            sectionHeader: true
          }, ...this.placeholderFiles];
        }
        return this.sectionsToItems;
      }
      return [];
    },
    showLoader() {
      return this.loading && (this.fileIds?.length !== 0 || this.sections?.length !== 0);
    }
  },
  mounted() {
    (0,_nextcloud_event_bus__WEBPACK_IMPORTED_MODULE_2__.subscribe)('files:file:updated', this.handleFileUpdated);
  },
  destroyed() {
    (0,_nextcloud_event_bus__WEBPACK_IMPORTED_MODULE_2__.unsubscribe)('files:file:updated', this.handleFileUpdated);
  },
  methods: {
    ...(0,vuex__WEBPACK_IMPORTED_MODULE_8__.mapActions)(['appendFiles']),
    // Ask the parent for more content.
    needContent() {
      this.$emit('need-content');
    },
    mapFileToItem(fileId) {
      const file = this.files[fileId];
      return {
        id: file.fileid,
        width: file.fileMetadataSizeParsed.width,
        height: file.fileMetadataSizeParsed.height,
        ratio: this.croppedLayout ? 1 : file.fileMetadataSizeParsed.width / file.fileMetadataSizeParsed.height
      };
    },
    /**
     * @param {object} data
     * @param {string} data.fileid - The file id of the updated file.
     */
    async handleFileUpdated(_ref) {
      let {
        fileid
      } = _ref;
      const fetchedFile = await (0,_services_fileFetcher_js__WEBPACK_IMPORTED_MODULE_4__.fetchFile)(this.files[fileid].filename);
      this.appendFiles([fetchedFile]);
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledLayout.vue?vue&type=script&lang=js&":
/*!*********************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledLayout.vue?vue&type=script&lang=js& ***!
  \*********************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _services_logger_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../services/logger.js */ "./src/services/logger.js");
/* harmony import */ var _services_TiledLayout_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../services/TiledLayout.js */ "./src/services/TiledLayout.js");
/* harmony import */ var _TiledRows_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TiledRows.vue */ "./src/components/TiledLayout/TiledRows.vue");
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'TiledLayout',
  components: {
    TiledRows: _TiledRows_vue__WEBPACK_IMPORTED_MODULE_2__["default"]
  },
  props: {
    items: {
      type: Array,
      required: true
    },
    baseHeight: {
      type: Number,
      default: 200
    }
  },
  data() {
    return {
      containerWidth: 0,
      /** @type {ResizeObserver} */
      resizeObserver: null
    };
  },
  computed: {
    /** @return {import('../services/TiledLayout.js').TiledRow[]} */
    rows() {
      _services_logger_js__WEBPACK_IMPORTED_MODULE_0__["default"].debug('[TiledLayout] Computing rows', {
        items: this.items
      });
      return (0,_services_TiledLayout_js__WEBPACK_IMPORTED_MODULE_1__.splitItemsInRows)(this.items, this.containerWidth, this.baseHeight);
    }
  },
  mounted() {
    this.resizeObserver = new ResizeObserver(entries => {
      for (const entry of entries) {
        const cr = entry.contentRect;
        if (entry.target.classList.contains('tiled-container')) {
          this.containerWidth = cr.width;
        }
      }
    });
    this.resizeObserver.observe(this.$refs.tiledLayoutContainer);
  },
  beforeDestroy() {
    this.resizeObserver.disconnect();
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/VirtualScrolling.vue?vue&type=script&lang=js&":
/*!**************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/VirtualScrolling.vue?vue&type=script&lang=js& ***!
  \**************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var debounce__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! debounce */ "./node_modules/debounce/index.js");
/* harmony import */ var debounce__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(debounce__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _services_logger_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../services/logger.js */ "./src/services/logger.js");
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//



/**
 * @typedef {object} Row
 * @property {number} height - The height of the row.
 */

/**
 * @typedef {Row} VisibleRow
 * @property {'none'|'near'|'visible'} visibility - The visibility state of the row
 * @property {boolean} shouldRender - Whether the row should be renderer in the DOM
 */

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'VirtualScrolling',
  props: {
    rows: {
      type: Array,
      required: true
    },
    containerElement: {
      type: HTMLElement,
      default: null
    },
    useWindow: {
      type: Boolean,
      default: false
    },
    renderWindowRatio: {
      type: Number,
      default: 4
    },
    willBeVisibleWindowRatio: {
      type: Number,
      default: 4
    },
    visibleWindowRatio: {
      type: Number,
      // A little bit more than the container's height to include items at its edges.
      default: 0
    },
    bottomBufferRatio: {
      type: Number,
      default: 5
    },
    scrollToKey: {
      type: String,
      default: ''
    }
  },
  data() {
    return {
      scrollPosition: 0,
      containerHeight: 0,
      rowsContainerHeight: 0,
      /** @type {ResizeObserver} */
      resizeObserver: null
    };
  },
  computed: {
    /**
     * @return {VisibleRow[]}
     */
    visibleRows() {
      _services_logger_js__WEBPACK_IMPORTED_MODULE_1__["default"].debug('[VirtualScrolling] Computing visible rows', this.rows);

      // Optimisation: get those computed properties once to not go through vue's internal every time we need them.
      const scrollPosition = this.scrollPosition;
      const containerHeight = this.containerHeight;

      // Optimisation: different windows to hint the items how they should render themselves.
      // This will be forwarded with the visibility props.
      const shouldRenderedWindow = containerHeight * this.renderWindowRatio;
      const willBeVisibleWindow = containerHeight * this.willBeVisibleWindowRatio;
      const visibleWindow = containerHeight * this.visibleWindowRatio;
      let currentRowTopDistanceFromTop = 0;
      let currentRowBottomDistanceFromTop = 0;

      // Compute whether a row should be included in the DOM (shouldRender)
      // And how visible the row is.
      return this.rows.reduce((visibleRows, row) => {
        currentRowTopDistanceFromTop = currentRowBottomDistanceFromTop;
        currentRowBottomDistanceFromTop += row.height;
        if (currentRowTopDistanceFromTop < scrollPosition - shouldRenderedWindow || scrollPosition + containerHeight + shouldRenderedWindow < currentRowTopDistanceFromTop) {
          return visibleRows;
        }
        let visibility = 'none';
        if (scrollPosition - willBeVisibleWindow < currentRowTopDistanceFromTop && currentRowTopDistanceFromTop < scrollPosition + containerHeight + willBeVisibleWindow) {
          visibility = 'near';
          if (scrollPosition - visibleWindow < currentRowTopDistanceFromTop && currentRowTopDistanceFromTop < scrollPosition + containerHeight + visibleWindow) {
            visibility = 'visible';
          }
          if (scrollPosition - visibleWindow < currentRowBottomDistanceFromTop && currentRowBottomDistanceFromTop < scrollPosition + containerHeight + visibleWindow) {
            visibility = 'visible';
          }
        }
        return [...visibleRows, {
          ...row,
          visibility
        }];
      }, []);
    },
    /**
     * Total height of all the rows + some room for the loader.
     *
     * @return {number}
     */
    rowsHeight() {
      const loaderHeight = 200;
      return this.rows.map(row => row.height).reduce((totalHeight, rowHeight) => totalHeight + rowHeight, 0) + loaderHeight;
    },
    /**
     * @return {number}
     */
    paddingTop() {
      if (this.visibleRows.length === 0) {
        return 0;
      }
      const firstVisibleRowIndex = this.rows.findIndex(row => row.items === this.visibleRows[0].items);
      return this.rows.map(row => row.height).slice(0, firstVisibleRowIndex).reduce((totalHeight, rowHeight) => totalHeight + rowHeight, 0);
    },
    /**
     * padding-top is used to replace not included item in the container.
     *
     * @return {object}
     */
    rowsContainerStyle() {
      return {
        height: `${this.rowsHeight}px`,
        paddingTop: `${this.paddingTop}px`
      };
    },
    /**
     * Whether the user is near the bottom.
     * If true, then the need-content event will be emitted.
     *
     * @return {boolean}
     */
    isNearBottom() {
      const buffer = this.containerHeight * this.bottomBufferRatio;
      return this.scrollPosition + this.containerHeight >= this.rowsHeight - buffer;
    },
    /**
     * @return {HTMLElement}
     */
    container() {
      _services_logger_js__WEBPACK_IMPORTED_MODULE_1__["default"].debug('[VirtualScrolling] Computing container');
      if (this.containerElement !== null) {
        return this.containerElement;
      } else if (this.useWindow) {
        return window;
      } else {
        return this.$refs.container;
      }
    }
  },
  watch: {
    isNearBottom(value) {
      if (value) {
        this.$emit('need-content');
      }
    },
    rows() {
      // Re-emit need-content when rows is updated and isNearBottom is still true.
      // If the height of added rows is under `bottomBufferRatio`, `isNearBottom` will still be true so we need more content.
      if (this.isNearBottom) {
        this.$emit('need-content');
      }
    },
    scrollToKey(key) {
      let currentRowTopDistanceFromTop = 0;
      for (const row of this.rows) {
        if (row.key === key) {
          this.$refs.container.scrollTo({
            top: currentRowTopDistanceFromTop,
            behavior: 'smooth'
          });
          return;
        }
        currentRowTopDistanceFromTop += row.height;
      }
    }
  },
  mounted() {
    this.resizeObserver = new ResizeObserver(entries => {
      for (const entry of entries) {
        const cr = entry.contentRect;
        if (entry.target === this.container) {
          this.containerHeight = cr.height;
        }
        if (entry.target.classList.contains('vs-rows-container')) {
          this.rowsContainerHeight = cr.height;
        }
      }
    });
    if (this.useWindow) {
      window.addEventListener('resize', this.updateContainerSize);
      this.containerHeight = window.innerHeight;
    } else {
      this.resizeObserver.observe(this.container);
    }
    this.resizeObserver.observe(this.$refs.rowsContainer);
    this.container.addEventListener('scroll', this.updateScrollPosition);
  },
  beforeDestroy() {
    if (this.useWindow) {
      window.removeEventListener('resize', this.updateContainerSize);
    }
    this.resizeObserver.disconnect();
    this.container.removeEventListener('scroll', this.updateScrollPosition);
  },
  methods: {
    updateScrollPosition: (0,debounce__WEBPACK_IMPORTED_MODULE_0__.debounce)(function () {
      if (this.useWindow) {
        this.scrollPosition = this.container.scrollY;
      } else {
        this.scrollPosition = this.container.scrollTop;
      }
    }, 200),
    updateContainerSize() {
      this.containerHeight = window.innerHeight;
    }
  }
});

/***/ }),

/***/ "./src/mixins/FilesSelectionMixin.js":
/*!*******************************************!*\
  !*** ./src/mixins/FilesSelectionMixin.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * @copyright Copyright (c) 2019 Louis Chemineau <louis@chmn.me>
 *
 * @author Louis Chemineau <louis@chmn.me>
 *
 * @license AGPL-3.0-or-later
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'FilesSelectionMixin',
  data() {
    return {
      /** @type {Object<string, boolean>} */
      selection: {}
    };
  },
  watch: {
    $route() {
      this.resetSelection();
    }
  },
  methods: {
    onFileSelectToggle(_ref) {
      let {
        id,
        value
      } = _ref;
      this.$set(this.selection, id, value);
    },
    /**
     * @param {string[]} filesIds - The ids of the files to uncheck.
     */
    onUncheckFiles(filesIds) {
      filesIds.forEach(( /** @type {string} */filesId) => this.$set(this.selection, filesId, false));
    },
    resetSelection() {
      this.selection = {};
    }
  },
  computed: {
    /**
     * @return {string[]}
     */
    selectedFileIds() {
      return Object.keys(this.selection).filter(fileId => this.selection[fileId]);
    }
  }
});

/***/ }),

/***/ "./src/mixins/UserConfig.js":
/*!**********************************!*\
  !*** ./src/mixins/UserConfig.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _nextcloud_event_bus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @nextcloud/event-bus */ "./node_modules/@nextcloud/event-bus/dist/index.mjs");
/* harmony import */ var _nextcloud_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @nextcloud/router */ "./node_modules/@nextcloud/router/dist/index.js");
/* harmony import */ var _nextcloud_initial_state__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @nextcloud/initial-state */ "./node_modules/@nextcloud/initial-state/dist/index.esm.js");
/* harmony import */ var _nextcloud_axios__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @nextcloud/axios */ "./node_modules/@nextcloud/axios/dist/index.esm.js");
/**
 * @copyright Copyright (c) 2020 John Molakvoæ <skjnldsv@protonmail.com>
 *
 * @author John Molakvoæ <skjnldsv@protonmail.com>
 *
 * @license AGPL-3.0-or-later
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */





const eventName = 'photos:user-config-changed';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data() {
    const croppedLayoutLocalStorage = localStorage.getItem('photos:croppedLayout');
    return {
      croppedLayout: croppedLayoutLocalStorage !== null ? croppedLayoutLocalStorage === 'true' : (0,_nextcloud_initial_state__WEBPACK_IMPORTED_MODULE_2__.loadState)('photos', 'croppedLayout', 'false') === 'true',
      photosLocation: (0,_nextcloud_initial_state__WEBPACK_IMPORTED_MODULE_2__.loadState)('photos', 'photosLocation', '')
    };
  },
  created() {
    (0,_nextcloud_event_bus__WEBPACK_IMPORTED_MODULE_0__.subscribe)(eventName, this.updateLocalSetting);
  },
  beforeDestroy() {
    (0,_nextcloud_event_bus__WEBPACK_IMPORTED_MODULE_0__.unsubscribe)(eventName, this.updateLocalSetting);
  },
  methods: {
    updateLocalSetting(_ref) {
      let {
        setting,
        value
      } = _ref;
      this[setting] = value;
    },
    updateSetting(setting) {
      const value = this[setting];
      // Long time save setting
      _nextcloud_axios__WEBPACK_IMPORTED_MODULE_3__["default"].put((0,_nextcloud_router__WEBPACK_IMPORTED_MODULE_1__.generateUrl)('apps/photos/api/v1/config/' + setting), {
        value: value.toString()
      });
      // Current session save setting
      localStorage.setItem('photos:' + setting, value);
      // Visible elements update setting
      (0,_nextcloud_event_bus__WEBPACK_IMPORTED_MODULE_0__.emit)(eventName, {
        setting,
        value
      });
    }
  }
});

/***/ }),

/***/ "./src/services/TiledLayout.js":
/*!*************************************!*\
  !*** ./src/services/TiledLayout.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "splitItemsInRows": () => (/* binding */ splitItemsInRows)
/* harmony export */ });
/**
 * @copyright Copyright (c) 2022 Louis Chemineau <louis@chmn.me>
 *
 * @author Louis Chemineau <louis@chmn.me>
 *
 * @license AGPL-3.0-or-later
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */

/**
 * @typedef {object} TiledItem
 * @property {string} id
 * @property {number} [width] Real width of the item.
 * @property {number} height Real height of the item.
 * @property {number} [ratio] The aspect ratio of the item.
 * @property {boolean} [sectionHeader] Whether this row is a section header.
 */

/**
 * @typedef {object} TiledRow
 * @property {TiledItem[]} items -
 * @property {number} height -
 * @property {string} key -
 */

/**
 * Split items in rows of equal width.
 * The last row will not be forced to match containerWidth.
 *
 * @param {TiledItem[]} items The list of item to split in row of equal width.
 * @param {number} containerWidth The width of a row.
 * @param {number} baseHeight The base height of the rows.
 * @return {TiledRow[]}
 */
function splitItemsInRows(items, containerWidth) {
  let baseHeight = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 200;
  if (containerWidth === 0) {
    return [];
  }
  const rows = [];
  let rowNumber = 0;
  let currentItem = 0;
  while (currentItem < items.length) {
    /** @type { TiledItem[] } */
    const rowItems = [];

    // Fill the row with new items as long as the width is less than containerWidth.
    do {
      // @ts-ignore - We know that items.shift() is not undefined as we always check that items.length > 0.
      rowItems.push(items[currentItem++]);
    } while (currentItem < items.length && !items[currentItem - 1].sectionHeader && !items[currentItem].sectionHeader && computeRowWidth([...rowItems, items[currentItem]], baseHeight) <= containerWidth);
    rows[rowNumber] = {
      items: rowItems,
      height: computeRowHeight(rowItems, containerWidth, items.length === currentItem || items[currentItem].sectionHeader === true, baseHeight),
      // Key to help vue to keep track of the row in VirtualScrolling.
      key: rowItems.map(item => item.id).join('-')
    };
    rowNumber += 1;
  }
  return rows;
}

/**
 *
 * @param {TiledItem[]} items The list of items in the row.
 * @param {number} baseHeight The base height of the rows.
 * @return {number} The width of the row
 */
function computeRowWidth(items, baseHeight) {
  return items.map(item => baseHeight * item.ratio).reduce((sum, itemWidth) => sum + itemWidth);
}

/**
 * Compute the row height based on its items and on the container's width.
 *
 * Math time !
 * With Rn the aspect ratio of item n
 *      Wn the width of item n
 *      Hn the height of item n
 *      Wc the width of the container
 *      Hr the height of the row
 * For n items we want: Wc = W1 + W2 + ... + Wn
 * We know Rn = Wn / Hn
 * So Wn = Rn * Hn
 * So Wc = (R1 * H1) + (R2 * H2) + ... + (Rn * Hn)
 * But we also want Hr === H1 === H2 === ... === Hn
 * So Wc = (R1 * Hr) + (R2 * Hr) + ... + (Rn * Hr)
 * So Wc = Hr * (R1 + R2 + ... + Rn)
 * So Hr = Wc / (R1 + R2 + ... + Rn)
 *
 * @param {TiledItem[]} items The list of items in the row.
 * @param {number} containerWidth The width of the row.
 * @param {boolean} isLastRow Whether we are computing the height for the last row.
 * @param {number} baseHeight The base height of the rows.
 * @return {number} The height of the row
 */
function computeRowHeight(items, containerWidth, isLastRow, baseHeight) {
  // Exception 1: there is only one item and its width it is a sectionHeader, meaning take the full width.
  if (items.length === 1 && items[0].sectionHeader) {
    return items[0].height;
  }
  const sumOfItemsRatio = items.map(item => item.ratio).reduce((sum, itemRatio) => sum + itemRatio);
  let rowHeight = containerWidth / sumOfItemsRatio;

  // Exception 2: there is only one item which is larger than containerWidth.
  // Limit its height so that itemWidth === containerWidth
  if (items.length === 1 && items[0].width > containerWidth) {
    rowHeight = containerWidth / items[0].ratio;
  }

  // Exception 3: we reached the last row.
  // Force the items width to match containerWidth, and limit their heigh to baseHeight + 20.
  if (isLastRow) {
    rowHeight = Math.min(baseHeight + 20, rowHeight);
  }
  return rowHeight;
}

/***/ }),

/***/ "./src/services/fileFetcher.js":
/*!*************************************!*\
  !*** ./src/services/fileFetcher.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "fetchFile": () => (/* binding */ fetchFile)
/* harmony export */ });
/* harmony import */ var _utils_fileUtils_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/fileUtils.js */ "./src/utils/fileUtils.js");
/* harmony import */ var _DavClient_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DavClient.js */ "./src/services/DavClient.js");
/**
 * @copyright Copyright (c) 2023 Louis Chemineau <louis@chmn.me>
 *
 * @author Louis Chemineau <louis@chmn.me>
 *
 * @license AGPL-3.0-or-later
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */




/**
 * @param {string[]} extraProps - Extra properties to add to the DAV request.
 * @return {string}
 */
function getCollectionFilesDavRequest() {
  let extraProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  return `<?xml version="1.0"?>
			<d:propfind xmlns:d="DAV:"
				xmlns:oc="http://owncloud.org/ns"
				xmlns:nc="http://nextcloud.org/ns"
				xmlns:ocs="http://open-collaboration-services.org/ns">
				<d:prop>
					<d:getcontentlength />
					<d:getcontenttype />
					<d:getetag />
					<d:getlastmodified />
					<d:resourcetype />
					<nc:file-metadata-size />
					<nc:has-preview />
					<oc:favorite />
					<oc:fileid />
					<oc:permissions />
					${extraProps.join('')}
				</d:prop>
			</d:propfind>`;
}

/**
 * @param {string} fileName - The full file's name
 * @param {import('webdav').StatOptions} options - Options to forward to the webdav client.
 * @return {Promise<object>}
 */
async function fetchFile(fileName) {
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  try {
    const response = await _DavClient_js__WEBPACK_IMPORTED_MODULE_1__["default"].stat(fileName, {
      data: getCollectionFilesDavRequest(),
      details: true,
      ...options
    });
    return (0,_utils_fileUtils_js__WEBPACK_IMPORTED_MODULE_0__.genFileInfo)(response.data);
  } catch (error) {
    if (error.code === 'ERR_CANCELED') {
      return null;
    }
    throw error;
  }
}

/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/File.vue?vue&type=style&index=0&id=ab80f8a8&lang=scss&scoped=true&":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/File.vue?vue&type=style&index=0&id=ab80f8a8&lang=scss&scoped=true& ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../node_modules/css-loader/dist/runtime/noSourceMaps.js */ "./node_modules/css-loader/dist/runtime/noSourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, ".file-container[data-v-ab80f8a8] {\n  background: var(--color-primary-light);\n  position: relative;\n  height: 100%;\n  width: 100%;\n  border: 2px solid var(--color-main-background);\n  box-sizing: border-box;\n}\n.file-container.selected[data-v-ab80f8a8]::after, .file-container[data-v-ab80f8a8]:focus-within::after {\n  position: absolute;\n  top: 0;\n  left: 0;\n  z-index: 2;\n  width: 100%;\n  height: 100%;\n  content: \"\";\n  outline: var(--color-primary) solid 4px;\n  outline-offset: -4px;\n  pointer-events: none;\n}\n.file-container .file[data-v-ab80f8a8] {\n  width: 100%;\n  height: 100%;\n  box-sizing: border-box;\n  outline: none;\n  display: flex;\n}\n.file-container .file__images[data-v-ab80f8a8] {\n  display: contents;\n}\n.file-container .file__images .video-icon[data-v-ab80f8a8] {\n  position: absolute;\n  top: 0px;\n  right: 0px;\n  width: 100%;\n  height: 100%;\n  z-index: 1;\n  opacity: 0.8;\n}\n.file-container .file__images .video-icon[data-v-ab80f8a8] :deep(.material-design-icon__svg) {\n  fill: var(--color-main-background);\n}\n.file-container .file__images img[data-v-ab80f8a8] {\n  width: 100%;\n  height: 100%;\n  object-fit: cover;\n  position: absolute;\n  color: transparent;\n}\n.file-container .file__images .loading-overlay[data-v-ab80f8a8] {\n  position: absolute;\n  height: 100%;\n  width: 100%;\n  display: flex;\n  align-content: center;\n  align-items: center;\n  justify-content: center;\n}\n.file-container .file__images .loading-overlay svg[data-v-ab80f8a8] {\n  width: 70%;\n  height: 70%;\n}\n.file-container .file__hidden-description[data-v-ab80f8a8] {\n  position: absolute;\n  left: -10000px;\n  top: -10000px;\n  width: 1px;\n  height: 1px;\n  overflow: hidden;\n}\n.file-container .file__hidden-description.show[data-v-ab80f8a8] {\n  position: initial;\n  width: fit-content;\n  height: fit-content;\n}\n.file-container:hover .selection-checkbox[data-v-ab80f8a8], .file-container.selected .selection-checkbox[data-v-ab80f8a8], .file-container:focus-within .selection-checkbox[data-v-ab80f8a8] {\n  display: flex;\n}\n.file-container:hover .favorite-state[data-v-ab80f8a8], .file-container.selected .favorite-state[data-v-ab80f8a8], .file-container:focus-within .favorite-state[data-v-ab80f8a8] {\n  display: none;\n}\n.file-container .selection-checkbox[data-v-ab80f8a8] {\n  display: none;\n  position: absolute;\n  top: 8px;\n  right: min(22px, 50% - 7px);\n  z-index: 1;\n  width: fit-content;\n}\n.file-container .selection-checkbox[data-v-ab80f8a8] :deep(.checkbox-radio-switch__label) {\n  padding: 10px;\n  box-sizing: border-box;\n}\n.file-container .selection-checkbox[data-v-ab80f8a8] :deep(.checkbox-radio-switch__label)::after {\n  content: \"\";\n  background: var(--color-primary-light);\n  width: 16px;\n  height: 16px;\n  position: absolute;\n  left: 14px;\n  z-index: -1;\n}\n.file-container .selection-checkbox :deep(.checkbox-radio-switch__label) .checkbox-radio-switch__icon[data-v-ab80f8a8] {\n  margin: 0;\n}\n.file-container .selection-checkbox .input-label[data-v-ab80f8a8] {\n  position: fixed;\n  z-index: -1;\n  top: -5000px;\n  left: -5000px;\n}\n.file-container .favorite-state[data-v-ab80f8a8] {\n  position: absolute;\n  top: 2px;\n  right: min(2px, 50% - 7px);\n}\n.file-container .favorite-state[data-v-ab80f8a8] :deep(.material-design-icon__svg) {\n  fill: #FC0;\n}\n.file-container .favorite-state :deep(.material-design-icon__svg) path[data-v-ab80f8a8] {\n  stroke: var(--color-primary-light);\n  stroke-width: 1px;\n}", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/FilesListViewer.vue?vue&type=style&index=0&id=3ebf26b2&lang=scss&scoped=true&":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/FilesListViewer.vue?vue&type=style&index=0&id=3ebf26b2&lang=scss&scoped=true& ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../node_modules/css-loader/dist/runtime/noSourceMaps.js */ "./node_modules/css-loader/dist/runtime/noSourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, ".files-list-viewer[data-v-3ebf26b2] {\n  height: 100%;\n  position: relative;\n}\n.files-list-viewer__placeholder[data-v-3ebf26b2] {\n  background: var(--color-primary-light);\n  width: 100%;\n  height: 100%;\n  border: 2px solid var(--color-main-background);\n}\n.files-list-viewer .tiled-container[data-v-3ebf26b2] {\n  flex-basis: 0;\n}\n.files-list-viewer ul[data-v-3ebf26b2] {\n  display: flex;\n  flex-wrap: wrap;\n}\n.files-list-viewer ul li[data-v-3ebf26b2] {\n  flex-grow: 1;\n}\n.files-list-viewer__section-header[data-v-3ebf26b2] {\n  position: sticky;\n  top: 0;\n  z-index: 3;\n  background: var(--color-main-background);\n}\n.files-list-viewer__loader[data-v-3ebf26b2] {\n  margin: 50px 0;\n}", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledLayout.vue?vue&type=style&index=0&id=d8ebab5e&scoped=true&lang=scss&":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledLayout.vue?vue&type=style&index=0&id=d8ebab5e&scoped=true&lang=scss& ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/noSourceMaps.js */ "./node_modules/css-loader/dist/runtime/noSourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, ".tiled-container[data-v-d8ebab5e] {\n  height: 100%;\n}\n.tiled-container .tiled-row[data-v-d8ebab5e] {\n  display: flex;\n}", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledRows.vue?vue&type=style&index=0&id=20864d80&lang=scss&scoped=true&":
/*!*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledRows.vue?vue&type=style&index=0&id=20864d80&lang=scss&scoped=true& ***!
  \*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/noSourceMaps.js */ "./node_modules/css-loader/dist/runtime/noSourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, ".tiled-row[data-v-20864d80] {\n  display: flex;\n}", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/VirtualScrolling.vue?vue&type=style&index=0&id=3d9f7b4c&scoped=true&lang=scss&":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/VirtualScrolling.vue?vue&type=style&index=0&id=3d9f7b4c&scoped=true&lang=scss& ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../node_modules/css-loader/dist/runtime/noSourceMaps.js */ "./node_modules/css-loader/dist/runtime/noSourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_noSourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, ".vs-container[data-v-3d9f7b4c] {\n  overflow-y: scroll;\n  height: 100%;\n}\n.vs-rows-container[data-v-3d9f7b4c] {\n  box-sizing: border-box;\n}", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/File.vue?vue&type=style&index=0&id=ab80f8a8&lang=scss&scoped=true&":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/File.vue?vue&type=style&index=0&id=ab80f8a8&lang=scss&scoped=true& ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_File_vue_vue_type_style_index_0_id_ab80f8a8_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../node_modules/css-loader/dist/cjs.js!../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../node_modules/postcss-loader/dist/cjs.js!../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!../../node_modules/vue-loader/lib/index.js??vue-loader-options!./File.vue?vue&type=style&index=0&id=ab80f8a8&lang=scss&scoped=true& */ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/File.vue?vue&type=style&index=0&id=ab80f8a8&lang=scss&scoped=true&");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_File_vue_vue_type_style_index_0_id_ab80f8a8_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_File_vue_vue_type_style_index_0_id_ab80f8a8_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_File_vue_vue_type_style_index_0_id_ab80f8a8_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_File_vue_vue_type_style_index_0_id_ab80f8a8_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/FilesListViewer.vue?vue&type=style&index=0&id=3ebf26b2&lang=scss&scoped=true&":
/*!*****************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/FilesListViewer.vue?vue&type=style&index=0&id=3ebf26b2&lang=scss&scoped=true& ***!
  \*****************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_FilesListViewer_vue_vue_type_style_index_0_id_3ebf26b2_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../node_modules/css-loader/dist/cjs.js!../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../node_modules/postcss-loader/dist/cjs.js!../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!../../node_modules/vue-loader/lib/index.js??vue-loader-options!./FilesListViewer.vue?vue&type=style&index=0&id=3ebf26b2&lang=scss&scoped=true& */ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/FilesListViewer.vue?vue&type=style&index=0&id=3ebf26b2&lang=scss&scoped=true&");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_FilesListViewer_vue_vue_type_style_index_0_id_3ebf26b2_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_FilesListViewer_vue_vue_type_style_index_0_id_3ebf26b2_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_FilesListViewer_vue_vue_type_style_index_0_id_3ebf26b2_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_FilesListViewer_vue_vue_type_style_index_0_id_3ebf26b2_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledLayout.vue?vue&type=style&index=0&id=d8ebab5e&scoped=true&lang=scss&":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledLayout.vue?vue&type=style&index=0&id=d8ebab5e&scoped=true&lang=scss& ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledLayout_vue_vue_type_style_index_0_id_d8ebab5e_scoped_true_lang_scss___WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js!../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../node_modules/postcss-loader/dist/cjs.js!../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./TiledLayout.vue?vue&type=style&index=0&id=d8ebab5e&scoped=true&lang=scss& */ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledLayout.vue?vue&type=style&index=0&id=d8ebab5e&scoped=true&lang=scss&");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledLayout_vue_vue_type_style_index_0_id_d8ebab5e_scoped_true_lang_scss___WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledLayout_vue_vue_type_style_index_0_id_d8ebab5e_scoped_true_lang_scss___WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledLayout_vue_vue_type_style_index_0_id_d8ebab5e_scoped_true_lang_scss___WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledLayout_vue_vue_type_style_index_0_id_d8ebab5e_scoped_true_lang_scss___WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledRows.vue?vue&type=style&index=0&id=20864d80&lang=scss&scoped=true&":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledRows.vue?vue&type=style&index=0&id=20864d80&lang=scss&scoped=true& ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledRows_vue_vue_type_style_index_0_id_20864d80_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js!../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../node_modules/postcss-loader/dist/cjs.js!../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./TiledRows.vue?vue&type=style&index=0&id=20864d80&lang=scss&scoped=true& */ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledRows.vue?vue&type=style&index=0&id=20864d80&lang=scss&scoped=true&");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledRows_vue_vue_type_style_index_0_id_20864d80_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledRows_vue_vue_type_style_index_0_id_20864d80_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledRows_vue_vue_type_style_index_0_id_20864d80_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledRows_vue_vue_type_style_index_0_id_20864d80_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/VirtualScrolling.vue?vue&type=style&index=0&id=3d9f7b4c&scoped=true&lang=scss&":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/VirtualScrolling.vue?vue&type=style&index=0&id=3d9f7b4c&scoped=true&lang=scss& ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_VirtualScrolling_vue_vue_type_style_index_0_id_3d9f7b4c_scoped_true_lang_scss___WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../node_modules/css-loader/dist/cjs.js!../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../node_modules/postcss-loader/dist/cjs.js!../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!../../node_modules/vue-loader/lib/index.js??vue-loader-options!./VirtualScrolling.vue?vue&type=style&index=0&id=3d9f7b4c&scoped=true&lang=scss& */ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/VirtualScrolling.vue?vue&type=style&index=0&id=3d9f7b4c&scoped=true&lang=scss&");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_VirtualScrolling_vue_vue_type_style_index_0_id_3d9f7b4c_scoped_true_lang_scss___WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_VirtualScrolling_vue_vue_type_style_index_0_id_3d9f7b4c_scoped_true_lang_scss___WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_VirtualScrolling_vue_vue_type_style_index_0_id_3d9f7b4c_scoped_true_lang_scss___WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_VirtualScrolling_vue_vue_type_style_index_0_id_3d9f7b4c_scoped_true_lang_scss___WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./src/components/File.vue":
/*!*********************************!*\
  !*** ./src/components/File.vue ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _File_vue_vue_type_template_id_ab80f8a8_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./File.vue?vue&type=template&id=ab80f8a8&scoped=true& */ "./src/components/File.vue?vue&type=template&id=ab80f8a8&scoped=true&");
/* harmony import */ var _File_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./File.vue?vue&type=script&lang=js& */ "./src/components/File.vue?vue&type=script&lang=js&");
/* harmony import */ var _File_vue_vue_type_style_index_0_id_ab80f8a8_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./File.vue?vue&type=style&index=0&id=ab80f8a8&lang=scss&scoped=true& */ "./src/components/File.vue?vue&type=style&index=0&id=ab80f8a8&lang=scss&scoped=true&");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _File_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _File_vue_vue_type_template_id_ab80f8a8_scoped_true___WEBPACK_IMPORTED_MODULE_0__.render,
  _File_vue_vue_type_template_id_ab80f8a8_scoped_true___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "ab80f8a8",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "src/components/File.vue"
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);

/***/ }),

/***/ "./src/components/FilesListViewer.vue":
/*!********************************************!*\
  !*** ./src/components/FilesListViewer.vue ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FilesListViewer_vue_vue_type_template_id_3ebf26b2_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FilesListViewer.vue?vue&type=template&id=3ebf26b2&scoped=true& */ "./src/components/FilesListViewer.vue?vue&type=template&id=3ebf26b2&scoped=true&");
/* harmony import */ var _FilesListViewer_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FilesListViewer.vue?vue&type=script&lang=js& */ "./src/components/FilesListViewer.vue?vue&type=script&lang=js&");
/* harmony import */ var _FilesListViewer_vue_vue_type_style_index_0_id_3ebf26b2_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FilesListViewer.vue?vue&type=style&index=0&id=3ebf26b2&lang=scss&scoped=true& */ "./src/components/FilesListViewer.vue?vue&type=style&index=0&id=3ebf26b2&lang=scss&scoped=true&");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _FilesListViewer_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _FilesListViewer_vue_vue_type_template_id_3ebf26b2_scoped_true___WEBPACK_IMPORTED_MODULE_0__.render,
  _FilesListViewer_vue_vue_type_template_id_3ebf26b2_scoped_true___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "3ebf26b2",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "src/components/FilesListViewer.vue"
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);

/***/ }),

/***/ "./src/components/TiledLayout/TiledLayout.vue":
/*!****************************************************!*\
  !*** ./src/components/TiledLayout/TiledLayout.vue ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _TiledLayout_vue_vue_type_template_id_d8ebab5e_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TiledLayout.vue?vue&type=template&id=d8ebab5e&scoped=true& */ "./src/components/TiledLayout/TiledLayout.vue?vue&type=template&id=d8ebab5e&scoped=true&");
/* harmony import */ var _TiledLayout_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./TiledLayout.vue?vue&type=script&lang=js& */ "./src/components/TiledLayout/TiledLayout.vue?vue&type=script&lang=js&");
/* harmony import */ var _TiledLayout_vue_vue_type_style_index_0_id_d8ebab5e_scoped_true_lang_scss___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./TiledLayout.vue?vue&type=style&index=0&id=d8ebab5e&scoped=true&lang=scss& */ "./src/components/TiledLayout/TiledLayout.vue?vue&type=style&index=0&id=d8ebab5e&scoped=true&lang=scss&");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _TiledLayout_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _TiledLayout_vue_vue_type_template_id_d8ebab5e_scoped_true___WEBPACK_IMPORTED_MODULE_0__.render,
  _TiledLayout_vue_vue_type_template_id_d8ebab5e_scoped_true___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "d8ebab5e",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "src/components/TiledLayout/TiledLayout.vue"
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);

/***/ }),

/***/ "./src/components/TiledLayout/TiledRows.vue":
/*!**************************************************!*\
  !*** ./src/components/TiledLayout/TiledRows.vue ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _TiledRows_vue_vue_type_template_id_20864d80_scoped_true_functional_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TiledRows.vue?vue&type=template&id=20864d80&scoped=true&functional=true& */ "./src/components/TiledLayout/TiledRows.vue?vue&type=template&id=20864d80&scoped=true&functional=true&");
/* harmony import */ var _TiledRows_vue_vue_type_style_index_0_id_20864d80_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./TiledRows.vue?vue&type=style&index=0&id=20864d80&lang=scss&scoped=true& */ "./src/components/TiledLayout/TiledRows.vue?vue&type=style&index=0&id=20864d80&lang=scss&scoped=true&");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");

var script = {}
;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(
  script,
  _TiledRows_vue_vue_type_template_id_20864d80_scoped_true_functional_true___WEBPACK_IMPORTED_MODULE_0__.render,
  _TiledRows_vue_vue_type_template_id_20864d80_scoped_true_functional_true___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  true,
  null,
  "20864d80",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "src/components/TiledLayout/TiledRows.vue"
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);

/***/ }),

/***/ "./src/components/VirtualScrolling.vue":
/*!*********************************************!*\
  !*** ./src/components/VirtualScrolling.vue ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _VirtualScrolling_vue_vue_type_template_id_3d9f7b4c_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./VirtualScrolling.vue?vue&type=template&id=3d9f7b4c&scoped=true& */ "./src/components/VirtualScrolling.vue?vue&type=template&id=3d9f7b4c&scoped=true&");
/* harmony import */ var _VirtualScrolling_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./VirtualScrolling.vue?vue&type=script&lang=js& */ "./src/components/VirtualScrolling.vue?vue&type=script&lang=js&");
/* harmony import */ var _VirtualScrolling_vue_vue_type_style_index_0_id_3d9f7b4c_scoped_true_lang_scss___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./VirtualScrolling.vue?vue&type=style&index=0&id=3d9f7b4c&scoped=true&lang=scss& */ "./src/components/VirtualScrolling.vue?vue&type=style&index=0&id=3d9f7b4c&scoped=true&lang=scss&");
/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");



;


/* normalize component */

var component = (0,_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(
  _VirtualScrolling_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _VirtualScrolling_vue_vue_type_template_id_3d9f7b4c_scoped_true___WEBPACK_IMPORTED_MODULE_0__.render,
  _VirtualScrolling_vue_vue_type_template_id_3d9f7b4c_scoped_true___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns,
  false,
  null,
  "3d9f7b4c",
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "src/components/VirtualScrolling.vue"
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (component.exports);

/***/ }),

/***/ "./src/components/File.vue?vue&type=script&lang=js&":
/*!**********************************************************!*\
  !*** ./src/components/File.vue?vue&type=script&lang=js& ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_File_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../node_modules/babel-loader/lib/index.js!../../node_modules/vue-loader/lib/index.js??vue-loader-options!./File.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/File.vue?vue&type=script&lang=js&");
 /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_File_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./src/components/FilesListViewer.vue?vue&type=script&lang=js&":
/*!*********************************************************************!*\
  !*** ./src/components/FilesListViewer.vue?vue&type=script&lang=js& ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_FilesListViewer_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../node_modules/babel-loader/lib/index.js!../../node_modules/vue-loader/lib/index.js??vue-loader-options!./FilesListViewer.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/FilesListViewer.vue?vue&type=script&lang=js&");
 /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_FilesListViewer_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./src/components/TiledLayout/TiledLayout.vue?vue&type=script&lang=js&":
/*!*****************************************************************************!*\
  !*** ./src/components/TiledLayout/TiledLayout.vue?vue&type=script&lang=js& ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledLayout_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../node_modules/babel-loader/lib/index.js!../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./TiledLayout.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledLayout.vue?vue&type=script&lang=js&");
 /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledLayout_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./src/components/VirtualScrolling.vue?vue&type=script&lang=js&":
/*!**********************************************************************!*\
  !*** ./src/components/VirtualScrolling.vue?vue&type=script&lang=js& ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_VirtualScrolling_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../node_modules/babel-loader/lib/index.js!../../node_modules/vue-loader/lib/index.js??vue-loader-options!./VirtualScrolling.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/VirtualScrolling.vue?vue&type=script&lang=js&");
 /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_babel_loader_lib_index_js_node_modules_vue_loader_lib_index_js_vue_loader_options_VirtualScrolling_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./src/components/File.vue?vue&type=style&index=0&id=ab80f8a8&lang=scss&scoped=true&":
/*!*******************************************************************************************!*\
  !*** ./src/components/File.vue?vue&type=style&index=0&id=ab80f8a8&lang=scss&scoped=true& ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_style_loader_dist_cjs_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_File_vue_vue_type_style_index_0_id_ab80f8a8_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../node_modules/style-loader/dist/cjs.js!../../node_modules/css-loader/dist/cjs.js!../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../node_modules/postcss-loader/dist/cjs.js!../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!../../node_modules/vue-loader/lib/index.js??vue-loader-options!./File.vue?vue&type=style&index=0&id=ab80f8a8&lang=scss&scoped=true& */ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/File.vue?vue&type=style&index=0&id=ab80f8a8&lang=scss&scoped=true&");


/***/ }),

/***/ "./src/components/FilesListViewer.vue?vue&type=style&index=0&id=3ebf26b2&lang=scss&scoped=true&":
/*!******************************************************************************************************!*\
  !*** ./src/components/FilesListViewer.vue?vue&type=style&index=0&id=3ebf26b2&lang=scss&scoped=true& ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_style_loader_dist_cjs_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_FilesListViewer_vue_vue_type_style_index_0_id_3ebf26b2_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../node_modules/style-loader/dist/cjs.js!../../node_modules/css-loader/dist/cjs.js!../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../node_modules/postcss-loader/dist/cjs.js!../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!../../node_modules/vue-loader/lib/index.js??vue-loader-options!./FilesListViewer.vue?vue&type=style&index=0&id=3ebf26b2&lang=scss&scoped=true& */ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/FilesListViewer.vue?vue&type=style&index=0&id=3ebf26b2&lang=scss&scoped=true&");


/***/ }),

/***/ "./src/components/TiledLayout/TiledLayout.vue?vue&type=style&index=0&id=d8ebab5e&scoped=true&lang=scss&":
/*!**************************************************************************************************************!*\
  !*** ./src/components/TiledLayout/TiledLayout.vue?vue&type=style&index=0&id=d8ebab5e&scoped=true&lang=scss& ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_style_loader_dist_cjs_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledLayout_vue_vue_type_style_index_0_id_d8ebab5e_scoped_true_lang_scss___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../node_modules/style-loader/dist/cjs.js!../../../node_modules/css-loader/dist/cjs.js!../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../node_modules/postcss-loader/dist/cjs.js!../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./TiledLayout.vue?vue&type=style&index=0&id=d8ebab5e&scoped=true&lang=scss& */ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledLayout.vue?vue&type=style&index=0&id=d8ebab5e&scoped=true&lang=scss&");


/***/ }),

/***/ "./src/components/TiledLayout/TiledRows.vue?vue&type=style&index=0&id=20864d80&lang=scss&scoped=true&":
/*!************************************************************************************************************!*\
  !*** ./src/components/TiledLayout/TiledRows.vue?vue&type=style&index=0&id=20864d80&lang=scss&scoped=true& ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_style_loader_dist_cjs_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledRows_vue_vue_type_style_index_0_id_20864d80_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../node_modules/style-loader/dist/cjs.js!../../../node_modules/css-loader/dist/cjs.js!../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../node_modules/postcss-loader/dist/cjs.js!../../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./TiledRows.vue?vue&type=style&index=0&id=20864d80&lang=scss&scoped=true& */ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledRows.vue?vue&type=style&index=0&id=20864d80&lang=scss&scoped=true&");


/***/ }),

/***/ "./src/components/VirtualScrolling.vue?vue&type=style&index=0&id=3d9f7b4c&scoped=true&lang=scss&":
/*!*******************************************************************************************************!*\
  !*** ./src/components/VirtualScrolling.vue?vue&type=style&index=0&id=3d9f7b4c&scoped=true&lang=scss& ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_style_loader_dist_cjs_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_node_modules_sass_loader_dist_cjs_js_clonedRuleSet_2_0_rules_0_use_3_node_modules_vue_loader_lib_index_js_vue_loader_options_VirtualScrolling_vue_vue_type_style_index_0_id_3d9f7b4c_scoped_true_lang_scss___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../node_modules/style-loader/dist/cjs.js!../../node_modules/css-loader/dist/cjs.js!../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../node_modules/postcss-loader/dist/cjs.js!../../node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!../../node_modules/vue-loader/lib/index.js??vue-loader-options!./VirtualScrolling.vue?vue&type=style&index=0&id=3d9f7b4c&scoped=true&lang=scss& */ "./node_modules/style-loader/dist/cjs.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js!./node_modules/sass-loader/dist/cjs.js??clonedRuleSet-2[0].rules[0].use[3]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/VirtualScrolling.vue?vue&type=style&index=0&id=3d9f7b4c&scoped=true&lang=scss&");


/***/ }),

/***/ "./src/components/File.vue?vue&type=template&id=ab80f8a8&scoped=true&":
/*!****************************************************************************!*\
  !*** ./src/components/File.vue?vue&type=template&id=ab80f8a8&scoped=true& ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": () => (/* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_File_vue_vue_type_template_id_ab80f8a8_scoped_true___WEBPACK_IMPORTED_MODULE_0__.render),
/* harmony export */   "staticRenderFns": () => (/* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_File_vue_vue_type_template_id_ab80f8a8_scoped_true___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_File_vue_vue_type_template_id_ab80f8a8_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!../../node_modules/vue-loader/lib/index.js??vue-loader-options!./File.vue?vue&type=template&id=ab80f8a8&scoped=true& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/File.vue?vue&type=template&id=ab80f8a8&scoped=true&");


/***/ }),

/***/ "./src/components/FilesListViewer.vue?vue&type=template&id=3ebf26b2&scoped=true&":
/*!***************************************************************************************!*\
  !*** ./src/components/FilesListViewer.vue?vue&type=template&id=3ebf26b2&scoped=true& ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": () => (/* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_FilesListViewer_vue_vue_type_template_id_3ebf26b2_scoped_true___WEBPACK_IMPORTED_MODULE_0__.render),
/* harmony export */   "staticRenderFns": () => (/* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_FilesListViewer_vue_vue_type_template_id_3ebf26b2_scoped_true___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_FilesListViewer_vue_vue_type_template_id_3ebf26b2_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!../../node_modules/vue-loader/lib/index.js??vue-loader-options!./FilesListViewer.vue?vue&type=template&id=3ebf26b2&scoped=true& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/FilesListViewer.vue?vue&type=template&id=3ebf26b2&scoped=true&");


/***/ }),

/***/ "./src/components/TiledLayout/TiledLayout.vue?vue&type=template&id=d8ebab5e&scoped=true&":
/*!***********************************************************************************************!*\
  !*** ./src/components/TiledLayout/TiledLayout.vue?vue&type=template&id=d8ebab5e&scoped=true& ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": () => (/* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledLayout_vue_vue_type_template_id_d8ebab5e_scoped_true___WEBPACK_IMPORTED_MODULE_0__.render),
/* harmony export */   "staticRenderFns": () => (/* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledLayout_vue_vue_type_template_id_d8ebab5e_scoped_true___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledLayout_vue_vue_type_template_id_d8ebab5e_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./TiledLayout.vue?vue&type=template&id=d8ebab5e&scoped=true& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledLayout.vue?vue&type=template&id=d8ebab5e&scoped=true&");


/***/ }),

/***/ "./src/components/TiledLayout/TiledRows.vue?vue&type=template&id=20864d80&scoped=true&functional=true&":
/*!*************************************************************************************************************!*\
  !*** ./src/components/TiledLayout/TiledRows.vue?vue&type=template&id=20864d80&scoped=true&functional=true& ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": () => (/* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledRows_vue_vue_type_template_id_20864d80_scoped_true_functional_true___WEBPACK_IMPORTED_MODULE_0__.render),
/* harmony export */   "staticRenderFns": () => (/* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledRows_vue_vue_type_template_id_20864d80_scoped_true_functional_true___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_TiledRows_vue_vue_type_template_id_20864d80_scoped_true_functional_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!../../../node_modules/vue-loader/lib/index.js??vue-loader-options!./TiledRows.vue?vue&type=template&id=20864d80&scoped=true&functional=true& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledRows.vue?vue&type=template&id=20864d80&scoped=true&functional=true&");


/***/ }),

/***/ "./src/components/VirtualScrolling.vue?vue&type=template&id=3d9f7b4c&scoped=true&":
/*!****************************************************************************************!*\
  !*** ./src/components/VirtualScrolling.vue?vue&type=template&id=3d9f7b4c&scoped=true& ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": () => (/* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_VirtualScrolling_vue_vue_type_template_id_3d9f7b4c_scoped_true___WEBPACK_IMPORTED_MODULE_0__.render),
/* harmony export */   "staticRenderFns": () => (/* reexport safe */ _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_VirtualScrolling_vue_vue_type_template_id_3d9f7b4c_scoped_true___WEBPACK_IMPORTED_MODULE_0__.staticRenderFns)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_VirtualScrolling_vue_vue_type_template_id_3d9f7b4c_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!../../node_modules/vue-loader/lib/index.js??vue-loader-options!./VirtualScrolling.vue?vue&type=template&id=3d9f7b4c&scoped=true& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/VirtualScrolling.vue?vue&type=template&id=3d9f7b4c&scoped=true&");


/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/File.vue?vue&type=template&id=ab80f8a8&scoped=true&":
/*!*******************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/File.vue?vue&type=template&id=ab80f8a8&scoped=true& ***!
  \*******************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": () => (/* binding */ render),
/* harmony export */   "staticRenderFns": () => (/* binding */ staticRenderFns)
/* harmony export */ });
var render = function () {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c(
    "div",
    {
      staticClass: "file-container",
      class: { selected: _vm.selected },
      attrs: { "data-test": "media" },
    },
    [
      _c(
        "a",
        {
          staticClass: "file",
          attrs: { href: _vm.file.source, "aria-label": _vm.ariaLabel },
          on: {
            click: function ($event) {
              $event.stopPropagation()
              $event.preventDefault()
              return _vm.emitClick.apply(null, arguments)
            },
          },
        },
        [
          _c(
            "div",
            { staticClass: "file__images" },
            [
              _vm.file.mime.includes("video")
                ? _c("VideoIcon", {
                    staticClass: "video-icon",
                    attrs: { size: 64 },
                  })
                : _vm._e(),
              _vm._v(" "),
              _vm.visibility !== "none" &&
              _vm.canLoad &&
              !_vm.errorNear &&
              !_vm.loadedVisible
                ? _c("img", {
                    key: _vm.file.basename + "-near",
                    ref: "imgNear",
                    attrs: {
                      src: _vm.srcNear,
                      alt: _vm.file.basename,
                      "aria-describedby": _vm.ariaDescription,
                    },
                    on: { load: _vm.onLoadNear, error: _vm.onErrorNear },
                  })
                : _vm._e(),
              _vm._v(" "),
              (_vm.visibility === "visible" ||
                (_vm.loadedVisible && _vm.visibility === "near")) &&
              _vm.canLoad &&
              !_vm.errorVisible
                ? _c("img", {
                    key: _vm.file.basename + "-visible",
                    ref: "imgVisible",
                    attrs: {
                      src: _vm.srcVisible,
                      alt: _vm.file.basename,
                      "aria-describedby": _vm.ariaDescription,
                    },
                    on: { load: _vm.onLoadVisible, error: _vm.onErrorVisible },
                  })
                : _vm._e(),
            ],
            1
          ),
          _vm._v(" "),
          _c(
            "p",
            {
              staticClass: "file__hidden-description",
              class: { show: _vm.errorNear && _vm.errorVisible },
              attrs: { id: _vm.ariaDescription },
            },
            [_vm._v(_vm._s(_vm.file.basename))]
          ),
        ]
      ),
      _vm._v(" "),
      _vm.allowSelection
        ? _c(
            "NcCheckboxRadioSwitch",
            {
              staticClass: "selection-checkbox",
              attrs: { checked: _vm.selected },
              on: { "update:checked": _vm.onToggle },
            },
            [
              _c("span", { staticClass: "input-label" }, [
                _vm._v(
                  _vm._s(
                    _vm.t("photos", "Select image {imageName}", {
                      imageName: _vm.file.basename,
                    })
                  )
                ),
              ]),
            ]
          )
        : _vm._e(),
      _vm._v(" "),
      _vm.file.favorite === 1
        ? _c("Star", {
            staticClass: "favorite-state",
            attrs: {
              "aria-label": _vm.t("photos", "The file is in the favorites"),
            },
          })
        : _vm._e(),
    ],
    1
  )
}
var staticRenderFns = []
render._withStripped = true



/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/FilesListViewer.vue?vue&type=template&id=3ebf26b2&scoped=true&":
/*!******************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/FilesListViewer.vue?vue&type=template&id=3ebf26b2&scoped=true& ***!
  \******************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": () => (/* binding */ render),
/* harmony export */   "staticRenderFns": () => (/* binding */ staticRenderFns)
/* harmony export */ });
var render = function () {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c(
    "div",
    { staticClass: "files-list-viewer" },
    [
      _vm.emptyMessage !== "" && _vm.items.length === 0 && !_vm.loading
        ? _c(
            "NcEmptyContent",
            { key: "emptycontent", attrs: { title: _vm.emptyMessage } },
            [_c("PackageVariant", { attrs: { slot: "icon" }, slot: "icon" })],
            1
          )
        : _vm._e(),
      _vm._v(" "),
      _c("TiledLayout", {
        attrs: { "base-height": _vm.baseHeight, items: _vm.items },
        scopedSlots: _vm._u([
          {
            key: "default",
            fn: function (ref) {
              var rows = ref.rows
              return _c(
                "VirtualScrolling",
                {
                  attrs: {
                    "use-window": _vm.useWindow,
                    "container-element": _vm.containerElement,
                    rows: rows,
                    "scroll-to-key": _vm.scrollToSection,
                  },
                  on: { "need-content": _vm.needContent },
                  scopedSlots: _vm._u([
                    {
                      key: "default",
                      fn: function (ref) {
                        var renderedRows = ref.renderedRows
                        return _c(
                          "ul",
                          {},
                          [
                            _vm._l(renderedRows, function (row) {
                              return _vm._l(row.items, function (item) {
                                return _c(
                                  "li",
                                  {
                                    key: item.id,
                                    class: {
                                      "files-list-viewer__section-header":
                                        item.sectionHeader,
                                    },
                                    style: {
                                      "flex-basis": item.ratio
                                        ? row.height * item.ratio - 1 + "px"
                                        : "100%",
                                      height: row.height + "px",
                                    },
                                  },
                                  [
                                    _vm.showPlaceholders
                                      ? _c("div", {
                                          staticClass:
                                            "files-list-viewer__placeholder",
                                        })
                                      : _vm._t("default", null, {
                                          file: item,
                                          visibility: row.visibility,
                                        }),
                                  ],
                                  2
                                )
                              })
                            }),
                          ],
                          2
                        )
                      },
                    },
                  ]),
                },
                [
                  _vm._v(" "),
                  _vm.loading && !_vm.showPlaceholders
                    ? _c("NcLoadingIcon", {
                        staticClass: "files-list-viewer__loader",
                        attrs: { slot: "loader" },
                        slot: "loader",
                      })
                    : _vm._e(),
                ],
                1
              )
            },
          },
        ]),
      }),
    ],
    1
  )
}
var staticRenderFns = []
render._withStripped = true



/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledLayout.vue?vue&type=template&id=d8ebab5e&scoped=true&":
/*!**************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledLayout.vue?vue&type=template&id=d8ebab5e&scoped=true& ***!
  \**************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": () => (/* binding */ render),
/* harmony export */   "staticRenderFns": () => (/* binding */ staticRenderFns)
/* harmony export */ });
var render = function () {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c(
    "div",
    { ref: "tiledLayoutContainer", staticClass: "tiled-container" },
    [
      _vm._t(
        "default",
        function () {
          return [_c("TiledRows", { attrs: { rows: _vm.rows } })]
        },
        { rows: _vm.rows }
      ),
    ],
    2
  )
}
var staticRenderFns = []
render._withStripped = true



/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledRows.vue?vue&type=template&id=20864d80&scoped=true&functional=true&":
/*!****************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/TiledLayout/TiledRows.vue?vue&type=template&id=20864d80&scoped=true&functional=true& ***!
  \****************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": () => (/* binding */ render),
/* harmony export */   "staticRenderFns": () => (/* binding */ staticRenderFns)
/* harmony export */ });
var render = function (_h, _vm) {
  var _c = _vm._c
  return _c(
    "ul",
    _vm._l(_vm.props.rows, function (row) {
      return _c(
        "div",
        {
          key: row.key,
          staticClass: "tiled-row",
          style: { height: row.height + "px" },
        },
        _vm._l(row.items, function (item) {
          return _c(
            "li",
            {
              key: item.id,
              style: {
                width: item.ratio ? row.height * item.ratio + "px" : "100%",
                height: row.height + "px",
              },
            },
            [_vm._t("default", null, { row: row, item: item })],
            2
          )
        }),
        0
      )
    }),
    0
  )
}
var staticRenderFns = []
render._withStripped = true



/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/VirtualScrolling.vue?vue&type=template&id=3d9f7b4c&scoped=true&":
/*!*******************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib/index.js??vue-loader-options!./src/components/VirtualScrolling.vue?vue&type=template&id=3d9f7b4c&scoped=true& ***!
  \*******************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "render": () => (/* binding */ render),
/* harmony export */   "staticRenderFns": () => (/* binding */ staticRenderFns)
/* harmony export */ });
var render = function () {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return !_vm.useWindow && _vm.containerElement === null
    ? _c("div", { ref: "container", staticClass: "vs-container" }, [
        _c(
          "div",
          {
            ref: "rowsContainer",
            staticClass: "vs-rows-container",
            style: _vm.rowsContainerStyle,
          },
          [
            _vm._t("default", null, { renderedRows: _vm.visibleRows }),
            _vm._v(" "),
            _vm._t("loader"),
          ],
          2
        ),
      ])
    : _c(
        "div",
        {
          ref: "rowsContainer",
          staticClass: "vs-rows-container",
          style: _vm.rowsContainerStyle,
        },
        [
          _vm._t("default", null, { renderedRows: _vm.visibleRows }),
          _vm._v(" "),
          _vm._t("loader"),
        ],
        2
      )
}
var staticRenderFns = []
render._withStripped = true



/***/ }),

/***/ "./src/assets/Illustrations/empty.svg":
/*!********************************************!*\
  !*** ./src/assets/Illustrations/empty.svg ***!
  \********************************************/
/***/ ((module) => {

module.exports = "<svg id=\"9af98f83-10c5-4067-bc84-20554b2827d8\" data-name=\"Layer 1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"1009.54\" height=\"789.93\" viewBox=\"0 0 1009.54 789.93\"><defs><linearGradient id=\"07c62293-c0d3-4921-8e06-4e39241449cd\" x1=\"318.22\" y1=\"488.45\" x2=\"630.35\" y2=\"488.45\" gradientUnits=\"userSpaceOnUse\"><stop offset=\"0\" stop-color=\"gray\" stop-opacity=\"0.25\"/><stop offset=\"0.54\" stop-color=\"gray\" stop-opacity=\"0.12\"/><stop offset=\"1\" stop-color=\"gray\" stop-opacity=\"0.1\"/></linearGradient></defs><title>empty</title><ellipse cx=\"354.13\" cy=\"741.27\" rx=\"176.1\" ry=\"33.36\" fill=\"#6c63ff\" opacity=\"0.1\"/><path d=\"M681.78,166.43c-64.72-2.24-126.36-23.14-185.22-46S379.4,72.25,316.23,60.14C275.6,52.35,229.13,51.24,196.4,73c-31.51,21-41.69,57.15-47.16,90.72-4.12,25.26-6.54,51.85,4.74,75.5,7.84,16.42,21.74,30.22,31.36,45.95,33.47,54.72,9.81,122.2-26.45,175.63-17,25.06-36.75,49-49.88,75.65S89.81,593.74,101.3,621c11.38,27,38.51,47.24,67.9,61.49,59.69,28.95,130,37.23,198.61,41.93,151.83,10.38,304.46,5.89,456.69,1.38,56.34-1.66,112.92-3.35,168.34-12.06,30.78-4.84,62.55-12.52,84.9-31.06,28.36-23.53,35.39-63.37,16.38-92.87-31.88-49.5-120-61.79-142.31-114.9-12.26-29.24.33-61.8,18.16-88.91,38.24-58.17,102.33-109.2,105.7-175.68,2.32-45.66-28.49-91.39-76.13-113-49.93-22.65-119.18-19.8-156,17.69C805.59,153.57,738.93,168.42,681.78,166.43Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\" opacity=\"0.1\"/><path d=\"M630.35,416.77l-30.63-20.65h0l15.45-23-80.9-6.45L505.2,389.15l-36.39-20.4-30.35,3.65-.36-8a225.78,225.78,0,0,0-2.51-24.9c.13-2.5.22-5.37.21-8.49,0-13.15-1.78-30.58-9.6-42.2L428,272.63,413.4,255.38a110.37,110.37,0,0,1,8-13.46c.5-.72,1-1.42,1.54-2.1,18.95-1.37,33.9-16.95,33.9-36,0-.88,0-1.76-.1-2.63,0-.35-.07-.71-.11-1.06,1.85,1,3.72,2,5.59,3,.35.5.75,1,1.19,1.59l0,0,.09.11.56.69.18.21c.2.24.41.47.62.71l.14.16c.53.59,1.09,1.19,1.69,1.78a1.8,1.8,0,0,1,.2.19l.75.7.21.19c.64.57,1.32,1.12,2,1.64l.22.16.86.59.28.18c.33.2.67.41,1,.6l.12.07c.39.21.79.41,1.19.6l.2.08q.51.22,1,.42l.31.11c.35.12.69.23,1.05.33l.22.06c.44.11.88.2,1.33.27h.05a10.88,10.88,0,0,0,1.28.13h.29a11,11,0,0,0,1.15,0h.25a11.85,11.85,0,0,0,1.43-.17,15.78,15.78,0,0,0,6.3-2.26,5.5,5.5,0,0,0,1.28-1.19c2-2.62-.2-5.49-.2-5.49h0c-.78-1.86-5.84-3.17-5.84-3.17s-16-6.68-16-12-4-32.92-45.29-39.23c0,0-26.86-1.51-34.41,12.87l-.16,1.68c-2.22,1.39-4.06,4.18-6.25,5a10.21,10.21,0,0,0-2.71,1l0-.19h0a2.58,2.58,0,0,0-.61.79,8,8,0,0,0-.83,3,11.3,11.3,0,0,1-1.31,3.63,8.07,8.07,0,0,1-.6.92h0l-.17.27a7.3,7.3,0,0,0,3.4-.55,16.93,16.93,0,0,1-1,4,3.32,3.32,0,0,0,3.08-1.84l0-.08.13-.18a8.44,8.44,0,0,0,.62-1.45l-.11.12c.2-.65.38-1.31.6-1.95a3.06,3.06,0,0,1,.49-1,2.42,2.42,0,0,1,2.07-.69l-.41,8.67h.18a11.83,11.83,0,0,1-.88,1.82c-1.42,2.3-4,3.87-4.95,6.39a9.4,9.4,0,0,0-.46,3.78c0,.75.09,1.51.15,2.26v-.06c.14,2,.18,3.9-.9,5.51-.74,1.1-1.93,1.93-2.34,3.18a3.1,3.1,0,0,0-.15,1.08,12.13,12.13,0,0,0,.68,3.21.14.14,0,0,0,0-.06,4.88,4.88,0,0,1,.17,2.36c-.45,2-2.88,3.67-2.76,5.58a2.15,2.15,0,0,0,.11.74,4.05,4.05,0,0,0,2.26,2,8.8,8.8,0,0,0,5.08,1.12,6.68,6.68,0,0,0,1.9-.65c-.7,1.61-1.42,3.2-2.15,4.71-.11.24-.23.48-.35.72,0,0-6.18-4.13-9.69,4.29a18.68,18.68,0,0,0-2.17,5.64,13.42,13.42,0,0,1-.74,2.32,14.93,14.93,0,0,1-6.68,6c-7.16,3.28-36.08,39.35-36.59,48.69a54.49,54.49,0,0,1-1.84,10.78,64.15,64.15,0,0,0-1.72,25.49,48.77,48.77,0,0,0,1.77,8.13c3.07,9.33,5.12,26.74,5.12,26.74l3.32,30.22a86,86,0,0,0,.54,12.49c-3.39,3.87-17,20-11.8,24.39,4,3.46,11,2.89,14.93,2.18-3.31,8.19-8.52,22.43-9.21,32.21-1,14.47,1.71,33.64,6,41s18.59,26.24,18.59,26.24-.67,25.9,4.44,35.31,7.17,28.93,7.17,28.93,4.77,16.48,2.38,22.54,4.43,11.1-2.73,15.13-16.32,94.86-16.32,94.86-3.69,59.53,0,62.56a3.75,3.75,0,0,0,.63.37v20s-2.56,4.2,7.85,5.05c7.13.57,27.34,1.86,39.33,2.61l9.29.58s22,4.38,31.72,0,26.95-4.28,24.39-15.85a32.92,32.92,0,0,0-1.36-4.63c-2.81-7.18-7.58-8-16.37-10-.51-.11-1-.21-1.45-.29-9.26-1.61-12.3,2.7-17.49-2.91-4.51-4.85-18.87-10.28-23.76-12,.12-.36.27-.71.39-1.08a7.32,7.32,0,0,1-3.71-1.81l13.25.84,7.89.49s18.7,3.73,27,0,22.9-3.63,20.72-13.46a28.21,28.21,0,0,0-1.15-3.94c-2.39-6.1-6.45-6.77-13.92-8.46-.43-.09-.83-.18-1.23-.25-7.87-1.37-10.45,2.29-14.86-2.47-3.78-4.06-15.71-8.61-20-10.16,0-2.22-3-5.38-4.89-8.55-2.22-3.7,1.88-16.65,1.88-16.65L411,658.74a10.38,10.38,0,0,1,2.8-.8s10.58-10.1,8.19-20.86a69.13,69.13,0,0,1-.76-9.83c3.48-3.23,8.27-8,9.63-10.94,2.22-4.79,0-28,0-28V499.56l17.7,1.79L464.62,503l4.89.5,16.06,1.62,36.91,3.73,33.26-6.3,14.39-2.72,29.59-5.6V421.83ZM386.74,176.86l-2.06-.22C385.36,176.67,386.08,176.8,386.74,176.86Z\" transform=\"translate(-95.23 -55.03)\" fill=\"url(#07c62293-c0d3-4921-8e06-4e39241449cd)\"/><path d=\"M558.56,463.78c-10,14.31-45.95,6.73-45.95,6.73l-27.86-26.07L481,440.91l6.29-13.36s2,.55,5.43,1.53C510.73,434.31,567,451.75,558.56,463.78Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#efb7b9\"/><path d=\"M492.7,429.08c-1.23,4.28-4.6,10.69-7.95,15.36L481,440.91l6.29-13.36S489.31,428.1,492.7,429.08Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M397.15,278.42s-25.68,11.39-24.42,39.36a461.14,461.14,0,0,0,5.88,53.76s-5.25,42.09,16.61,52.94,42.09,19.77,42.09,19.77,34.2,3.68,38.45,5.2,17.53-21.72,15.08-25.34S457,412.9,453,406.86s-13.25-9.77-13.25-9.77-9.55-5.78-10.2-11,1.87-9.11,2.51-11.4,2.26-24.4,2.26-24.4S445.1,271.59,397.15,278.42Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#dce6f2\"/><path d=\"M414.1,370.39s-35.23,5.9-31.82,18.23C382.28,388.62,395.07,375.31,414.1,370.39Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M414.37,375.38S395,391.19,398.79,392,414.37,375.38,414.37,375.38Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M423.68,380.89s-5.19,10.63-2,9.91S423.68,380.89,423.68,380.89Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M494,430.21l-2.14-.61c.61-2,.78-3.62.28-4.37-2.45-3.62-33.82-11.2-37.81-17.25s-13.25-9.77-13.25-9.77-9.55-5.78-10.2-11,1.87-9.11,2.51-11.4,2.26-24.41,2.26-24.41,10.75-78.69-37.2-71.86c0,0-25.68,11.4-24.43,39.37a459.85,459.85,0,0,0,5.89,53.76s-5.25,42.09,16.61,52.94,42.09,19.77,42.09,19.77,34.19,3.67,38.45,5.2c1.61.58,4.52-2.41,7.37-6.52l1.62,1.51,27.86,26.06s35.95,7.59,45.95-6.72C568.31,452.87,512.05,435.43,494,430.21Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M382.37,173.44a8.5,8.5,0,0,0-2.77,1.07c-1,.83-1,2.25-1.25,3.49a11.48,11.48,0,0,1-2,4.78,7.19,7.19,0,0,0,3.33-.55,17.14,17.14,0,0,1-1,4,3.24,3.24,0,0,0,3-1.83,19.26,19.26,0,0,0,1.25-3.51,2.89,2.89,0,0,1,.48-1c.92-1.09,2.63-.6,4.05-.46a6.65,6.65,0,0,0,6.08-2.92c1.51-2.29,1.6-8.15-2-8.77C387.78,167.12,385.44,172.3,382.37,173.44Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#965d7b\"/><g opacity=\"0.1\"><path d=\"M379.5,175.74c.09-.49.15-1,.26-1.49h0c-.95.83-1,2.24-1.25,3.49a11,11,0,0,1-.59,2.11A11.46,11.46,0,0,0,379.5,175.74Z\" transform=\"translate(-95.23 -55.03)\"/><path d=\"M379.82,184a16.63,16.63,0,0,0,1-4,7.16,7.16,0,0,1-3.17.55,11.57,11.57,0,0,1-1.15,2,7.12,7.12,0,0,0,3.32-.54,16.63,16.63,0,0,1-1,4,3.25,3.25,0,0,0,3-1.83,7.46,7.46,0,0,0,.6-1.43A3,3,0,0,1,379.82,184Z\" transform=\"translate(-95.23 -55.03)\"/><path d=\"M388.6,177.2c-1.42-.14-3.14-.63-4.06.46a3.09,3.09,0,0,0-.48,1c-.09.26-.17.53-.24.8.95-.75,2.49-.35,3.78-.22a6.68,6.68,0,0,0,6.08-2.92,5.54,5.54,0,0,0,.67-1.57A6.66,6.66,0,0,1,388.6,177.2Z\" transform=\"translate(-95.23 -55.03)\"/></g><polygon points=\"317.24 201 332.49 219.34 330.5 237.85 312.07 209 317.24 201\" fill=\"#dce6f2\"/><polygon points=\"332.48 219.34 330.61 236.75 330.49 237.85 313.86 211.81 312.07 209 312.59 208.19 317.23 201 318.26 202.24 332.48 219.34\" opacity=\"0.1\"/><path d=\"M435.63,231.2c-5.16,1.48-10.09,6.56-14.38,12.73a108.65,108.65,0,0,0-7.76,13.34c-1.41,2.82-2.65,5.53-3.68,7.89l-.72,1.68c-1.74,4.11-2.71,6.86-2.71,6.86S366.88,244,373.13,242c2.1-.67,4.86-5.17,7.59-10.84l.34-.72c1.73-3.64,3.43-7.7,4.94-11.52,3.09-7.85,5.38-14.67,5.38-14.67S451.38,226.7,435.63,231.2Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#efb7b9\"/><path d=\"M459.26,202.58s9.12,16.5,21.37,14.25,7.21-8.86,7.21-8.86Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#444053\"/><path d=\"M441.59,773.73c-8.08,3.69-26.35,0-26.35,0l-7.7-.48c-10-.64-26.74-1.72-32.66-2.2-8.64-.71-6.52-4.25-6.52-4.25V745.41l41.92-10.62s16.57,5.67,21.11,10.62c4.31,4.72,6.83,1.09,14.52,2.45.38.07.78.15,1.2.25,7.3,1.67,11.26,2.33,13.6,8.38a28.1,28.1,0,0,1,1.13,3.9C464,770.13,449.66,770.06,441.59,773.73Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#a36468\"/><path d=\"M460.71,756.49a31.34,31.34,0,0,1-4.72,2.42c-5.5,2.51-10.73,5.57-16.29,7.94s-11.55,4.06-17.57,3.61c-3.15-.23-6.37-1-9.38-.1a21.66,21.66,0,0,0-5.21,2.89c-10-.64-26.74-1.72-32.66-2.2-8.64-.71-6.52-4.25-6.52-4.25v-2.5c.31,0,.66-.09,1.06-.12a18.88,18.88,0,0,1,6.1.91c4.34,1.18,8.66,2.34,13,3.5a10.27,10.27,0,0,1,5-6.38,15.94,15.94,0,0,1,8.06-1.85c6.73.09,13.1,3.28,19.82,3.6a10.92,10.92,0,0,0,5.49-.92c.92-.46,1.73-1.13,2.63-1.64a19.2,19.2,0,0,1,4.53-1.53A99.76,99.76,0,0,0,447,755.69c1.2-.47,2.6-1.32,2.44-2.6-.21-1.7-2.88-1.9-3.58-3.46a2,2,0,0,1,.08-1.77c.38.07.78.15,1.2.25C454.41,749.78,458.37,750.44,460.71,756.49Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M433.05,820.53c-9.5,4.34-31,0-31,0L393,820c-11.72-.75-31.46-2-38.43-2.59-10.17-.84-7.67-5-7.67-5V787.2l49.33-12.5s19.5,6.67,24.84,12.5c5.07,5.55,8,1.28,17.09,2.88.45.08.92.18,1.41.29,8.59,2,13.25,2.75,16,9.87a32.1,32.1,0,0,1,1.33,4.59C459.38,816.29,442.55,816.2,433.05,820.53Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#a36468\"/><path d=\"M455.55,800.24a37.23,37.23,0,0,1-5.55,2.85c-6.47,2.95-12.63,6.55-19.17,9.34s-13.59,4.77-20.68,4.25c-3.7-.27-7.49-1.2-11-.12A25.5,25.5,0,0,0,393,820c-11.72-.75-31.46-2-38.43-2.59-10.17-.84-7.67-5-7.67-5v-2.94a12.5,12.5,0,0,1,1.25-.14,21.94,21.94,0,0,1,7.18,1.07l15.29,4.12a12.1,12.1,0,0,1,5.93-7.51,18.66,18.66,0,0,1,9.49-2.18c7.92.11,15.41,3.86,23.32,4.24A12.91,12.91,0,0,0,415.8,808c1.09-.55,2-1.34,3.1-1.93a21.75,21.75,0,0,1,5.33-1.8,119.69,119.69,0,0,0,15.16-4.92c1.41-.56,3.06-1.56,2.87-3.06-.25-2-3.39-2.24-4.22-4.08a2.41,2.41,0,0,1,.1-2.08c.45.08.92.18,1.41.29C448.14,792.34,452.8,793.12,455.55,800.24Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M411.55,647.54l-2.67,62.83s-4,12.83-1.83,16.5,5.83,7.33,4.5,9.5S394.22,762,389.05,753s-10.27-48-10.27-48l4.77-48.17Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#444053\"/><path d=\"M423.13,491l7.42,9.92V587.2s2.17,23,0,27.75-13.17,14.25-13.17,14.25l-9.25-47.5,2-50.25Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#444053\"/><path d=\"M411.55,647.54l-2.67,62.83s-4,12.83-1.83,16.5,5.83,7.33,4.5,9.5S394.22,762,389.05,753s-10.27-48-10.27-48l4.77-48.17Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M423.13,491l7.42,9.92V587.2s2.17,23,0,27.75-13.17,14.25-13.17,14.25l-9.25-47.5,2-50.25Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M430.55,454.2v46.67l-8.33,36.33s-2.67,87.67-.34,98.33-8,20.67-8,20.67-6,.67-6,5.33-10,18-10,18l.33,26s4.34,48.67-2.33,58,2.33,10.67,2.33,10.67c-8.33,27.33-48.33,21-51.94,18s0-62,0-62,8.94-90,15.94-94,.34-9,2.67-15-2.33-22.33-2.33-22.33-2-19.34-7-28.67-4.34-35-4.34-35-14-18.67-18.16-26-6.84-26.33-5.84-40.67c.68-9.69,5.77-23.8,9-31.92,1.55-3.89,2.67-6.41,2.67-6.41l.95.25,54.62,14.3Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#444053\"/><path d=\"M435.63,231.2c-5.16,1.48-10.09,6.56-14.38,12.73l-1.12,0a35.72,35.72,0,0,1-31-17.93,35.18,35.18,0,0,1-3.14-7.15c3.09-7.85,5.38-14.67,5.38-14.67S451.38,226.7,435.63,231.2Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M455.88,206.2A35.75,35.75,0,1,1,389,188.68a34.93,34.93,0,0,1,3.78-5.46A36.18,36.18,0,0,1,401,176a35.75,35.75,0,0,1,54.83,27.58C455.85,204.46,455.88,205.33,455.88,206.2Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#efb7b9\"/><path d=\"M425.84,291.78l-.12,1.1-16.63-26c-1.74,4.11-2.71,6.86-2.71,6.86S366.88,244,373.13,242c2.1-.67,4.86-5.17,7.59-10.84l.34-.72c2.9,8.64,19.75,25.91,26.76,32.83.81.8,1.48,1.46,2,1.94l1.07,1,.56.56C414,269.4,424.76,281,425.84,291.78Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M438.27,380l-1.82,58.57L436.13,449s-21.56-2-41.68-4.2c-16.2-1.77-31.47-3.68-33.82-4.8-3-1.41-9.43-2.5-14.5-3.19-3.92-.53-7-.81-7-.81s-1.15.34-2.92.66c-3.86.7-10.64,1.27-14.59-2.16-5.05-4.39,8.22-20.34,11.53-24.17l.73-.83-1.25-11.55L329.38,368s-2-17.25-5-26.5a48.88,48.88,0,0,1-1.73-8.05,64.48,64.48,0,0,1,1.68-25.26,55.08,55.08,0,0,0,1.8-10.69c.5-9.25,28.75-45,35.75-48.25a14.84,14.84,0,0,0,7.16-7.14,13.64,13.64,0,0,0,1.09-3.11c3-13,10.59-7.84,10.59-7.84,1.83,10.17,30.16,37.09,30.16,37.09l.56.56c2.81,2.88,15.33,16.4,14.44,27.94a33.87,33.87,0,0,0,1.89,12.64,213.75,213.75,0,0,1,9.85,56Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#dce6f2\"/><path d=\"M398.13,310.45s-7,17-12.25,19.75S400.63,336,398.13,310.45Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M403.38,342.2s-16,2-16,5S403.38,342.2,403.38,342.2Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M420.13,361.7s-23.25,49.5-29.75,51S420.13,361.7,420.13,361.7Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M410.44,270.76l-19.23,8.36L368,244.06a13.64,13.64,0,0,0,1.09-3.11c3-13,10.59-7.84,10.59-7.84,1.83,10.17,30.16,37.09,30.16,37.09Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M411.44,268.76l-19.23,8.36L369,242.06a13.64,13.64,0,0,0,1.09-3.11c3-13,10.59-7.84,10.59-7.84,1.83,10.17,30.16,37.09,30.16,37.09Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#dce6f2\"/><path d=\"M436.13,449s-21.56-2-41.68-4.2l36.1,9.45v11c-1.58,1.43-2.95,2.17-3.84,1.79-4.16-1.75-38.11-7.25-38.11-7.25s-19.72-10-41-22a16.43,16.43,0,0,1-1.5-.94,23.64,23.64,0,0,1-6.3-6.31c-3.93-5.69-5.85-13-6.68-20.17a87.22,87.22,0,0,1-.52-12.38A101.51,101.51,0,0,1,333.88,384a460.08,460.08,0,0,1-3-54c.25-28,26.5-38,26.5-38,48.25-4.25,33.29,73.75,33.29,73.75s-2.79,22-3.55,24.25-3.49,6-3.12,11.25,9.59,11.53,9.59,11.53,9,4.22,12.71,10.47c2.7,4.61,20.24,10.86,30.15,15.32Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M452.29,184a11.32,11.32,0,0,1-1,4.78,29.55,29.55,0,0,1-1.78,3.56,16.4,16.4,0,0,1-4.38,5.44c-2.31,1.65-5.23,2.11-8,2.78s-5.65,1.74-7.23,4.1a14.34,14.34,0,0,0-1.69,4.9,10.54,10.54,0,0,1-2,4.74,3.93,3.93,0,0,1-4.68,1.12,4.73,4.73,0,0,1-1.81-2.33c-1.14-2.57-1.43-5.42-1.89-8.19s-1.11-5.62-2.81-7.85-4.71-3.7-7.38-2.83a7.11,7.11,0,0,0-4,3.88,22.24,22.24,0,0,0-1.51,5.52q-1.86,10.18-4.39,20.24a1.86,1.86,0,0,1-.33.76,1.44,1.44,0,0,1-1,.42c-2.24.3-4.39-1.27-6.65-1.1a3.82,3.82,0,0,0-.69.11,35.73,35.73,0,0,1,3.61-40.8l.18-.05a10.78,10.78,0,0,0,4-2.52,42.22,42.22,0,0,0,4-4.63l.8-1a45.61,45.61,0,0,1,7.8-7.41,8,8,0,0,1,2.66-1.44,7.88,7.88,0,0,1,2.52-.08,63.57,63.57,0,0,0,10.41.39,66.79,66.79,0,0,1,7.31-.74c6.33.18,11.73,4.65,15.73,9.55C450.24,177.83,452.16,180.72,452.29,184Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M384.33,189.63c-1.39,2.28-3.9,3.83-4.84,6.33-1.38,3.63.95,8.15-1.19,11.39-.71,1.09-1.88,1.9-2.28,3.15-.68,2.11,1.18,4.36.7,6.53s-3.34,4-2.58,6.12a4,4,0,0,0,2.2,2,8.6,8.6,0,0,0,5,1.11c2.73-.45,4.76-3.13,7.53-3.33,2.25-.16,4.4,1.4,6.64,1.11a1.5,1.5,0,0,0,1-.43,1.73,1.73,0,0,0,.33-.76q2.52-10.05,4.4-20.24a21.8,21.8,0,0,1,1.5-5.52,7.17,7.17,0,0,1,4-3.88c2.67-.86,5.67.6,7.38,2.83s2.36,5.08,2.82,7.85.75,5.62,1.88,8.19a4.78,4.78,0,0,0,1.82,2.34c1.5.87,3.52.18,4.67-1.12a10.43,10.43,0,0,0,2-4.75,14.28,14.28,0,0,1,1.69-4.89c1.58-2.36,4.47-3.43,7.23-4.1s5.67-1.14,8-2.79a16.46,16.46,0,0,0,4.38-5.43c1.48-2.58,2.86-5.38,2.74-8.35-.13-3.24-2.05-6.13-4.1-8.65-4-4.9-9.41-9.37-15.74-9.54a62.2,62.2,0,0,0-7.31.74,62.57,62.57,0,0,1-10.41-.4,8.18,8.18,0,0,0-2.52.09,7.54,7.54,0,0,0-2.65,1.44,45.63,45.63,0,0,0-7.81,7.4,57.31,57.31,0,0,1-4.82,5.6,10.85,10.85,0,0,1-4,2.53c-1,.28-2,.08-2.95.39C386.09,183.52,385.7,187.37,384.33,189.63Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#965d7b\"/><path d=\"M480.63,216.82c-8,1.47-14.63-5-18.3-9.72a39.22,39.22,0,0,1-3.07-4.52l27.46,5.18,1.11.21S492.88,214.58,480.63,216.82Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><g opacity=\"0.1\"><path d=\"M376.72,214.17a8.33,8.33,0,0,0-.58-3.84c0,.1-.09.2-.12.3-.43,1.34.15,2.73.52,4.12A3,3,0,0,0,376.72,214.17Z\" transform=\"translate(-95.23 -55.03)\"/><path d=\"M379.1,197.8a22.22,22.22,0,0,0,.08,4.15A22.28,22.28,0,0,0,379.1,197.8Z\" transform=\"translate(-95.23 -55.03)\"/><path d=\"M448.55,188.45a16.4,16.4,0,0,1-4.38,5.44c-2.31,1.65-5.22,2.11-8,2.78s-5.65,1.74-7.23,4.1a14.41,14.41,0,0,0-1.69,4.9,10.47,10.47,0,0,1-2,4.75c-1.15,1.3-3.17,2-4.67,1.12a4.78,4.78,0,0,1-1.82-2.34c-1.13-2.57-1.43-5.41-1.88-8.19s-1.12-5.62-2.82-7.85-4.71-3.7-7.38-2.83a7.14,7.14,0,0,0-4,3.88,21.8,21.8,0,0,0-1.5,5.52q-1.87,10.19-4.4,20.24a1.73,1.73,0,0,1-.33.76,1.5,1.5,0,0,1-1,.43c-2.24.29-4.39-1.27-6.64-1.11-2.77.2-4.8,2.88-7.53,3.32a8.45,8.45,0,0,1-5-1.11,5.35,5.35,0,0,1-1.83-1.3,2.7,2.7,0,0,0-.37,2.33,3.9,3.9,0,0,0,2.2,2,8.45,8.45,0,0,0,5,1.11c2.73-.44,4.76-3.12,7.53-3.32,2.25-.16,4.4,1.4,6.64,1.11a1.5,1.5,0,0,0,1-.43,1.73,1.73,0,0,0,.33-.76q2.52-10,4.4-20.24a21.8,21.8,0,0,1,1.5-5.52,7.14,7.14,0,0,1,4-3.88c2.67-.87,5.67.6,7.38,2.83s2.36,5.08,2.82,7.85.75,5.62,1.88,8.19a4.78,4.78,0,0,0,1.82,2.34c1.5.87,3.52.18,4.67-1.12a10.47,10.47,0,0,0,2-4.75,14.41,14.41,0,0,1,1.69-4.9c1.58-2.36,4.47-3.42,7.23-4.1s5.67-1.13,8-2.78a16.4,16.4,0,0,0,4.38-5.44c1.48-2.57,2.86-5.37,2.74-8.34a10.74,10.74,0,0,0-.12-1.14A19.65,19.65,0,0,1,448.55,188.45Z\" transform=\"translate(-95.23 -55.03)\"/></g><path d=\"M451.33,188.75a35.33,35.33,0,0,1,4.45,14.85c-8.91-5-17.29-10.49-21.52-12.4-7.37-3.33-34.93-2.83-45.29-2.52a34.93,34.93,0,0,1,3.78-5.46A36.18,36.18,0,0,1,401,176a35.77,35.77,0,0,1,50.38,12.73Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M483.13,212.58c-4.81,1.48-12.66-1.38-20.8-5.48a39.22,39.22,0,0,1-3.07-4.52l27.46,5.18C488.54,209,489,210.77,483.13,212.58Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M422.26,154.08s-26.25-1.5-33.63,12.75l-1.19,12.63-2-.22-.4,8.59s40.12-1.75,49.25,2.37,37.5,24.88,48.87,21.38-1-6.75-1-6.75S466.51,198.2,466.51,193,462.63,160.33,422.26,154.08Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#444053\"/><path d=\"M371.63,622.28s16.75,16.25,24,15C395.63,637.28,375.13,635.53,371.63,622.28Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M368.13,629.81s1.5,8.36,5.5,7.54S368.13,629.81,368.13,629.81Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M394.38,769.53s-23.78,18.5-19.77,19S394.38,769.53,394.38,769.53Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><polygon points=\"330.96 347.33 407.96 334.8 407.96 407.7 334.8 403.87 330.96 347.33\" fill=\"#6c63ff\"/><polygon points=\"330.96 347.33 407.96 334.8 407.96 407.7 334.8 403.87 330.96 347.33\" opacity=\"0.05\"/><polygon points=\"407.96 334.8 500.3 341.71 495.19 405.15 407.96 407.7 407.96 334.8\" fill=\"#6c63ff\"/><polygon points=\"407.96 334.8 500.3 341.71 495.19 405.15 407.96 407.7 407.96 334.8\" opacity=\"0.1\"/><polygon points=\"436.35 312.55 407.96 334.8 500.3 341.71 515.39 318.94 436.35 312.55\" fill=\"#6c63ff\"/><polygon points=\"303.08 323.03 372.4 314.59 407.96 334.8 330.96 347.33 303.08 323.03\" fill=\"#6c63ff\"/><polygon points=\"424.84 353.73 424.84 453.4 388.77 449.7 373.08 448.1 368.3 447.6 352.62 445.99 330.96 443.77 330.96 347.33 407.95 352.57 424.84 353.73\" fill=\"#6c63ff\"/><polygon points=\"500.3 341.71 500.3 438.91 471.39 444.46 457.33 447.16 424.84 453.4 424.84 353.73 500.3 341.71\" fill=\"#6c63ff\"/><polygon points=\"500.3 341.71 500.3 438.91 471.39 444.46 457.33 447.16 424.84 453.4 424.84 353.73 500.3 341.71\" opacity=\"0.05\"/><polygon points=\"303.08 368.31 330.96 347.33 424.84 353.73 411.02 377.01 303.08 368.31\" fill=\"#6c63ff\"/><polygon points=\"303.08 368.31 330.96 347.33 424.84 353.73 411.02 377.01 303.08 368.31\" fill=\"#fff\" opacity=\"0.1\"/><polygon points=\"500.3 341.71 424.84 353.73 449.4 375.73 530.23 362.17 500.3 341.71\" fill=\"#6c63ff\"/><polygon points=\"500.3 341.71 424.84 353.73 449.4 375.73 530.23 362.17 500.3 341.71\" fill=\"#fff\" opacity=\"0.1\"/><polygon points=\"471.39 444.46 457.33 447.16 457.33 426.39 470.5 423.07 471.39 444.46\" fill=\"#fff\" opacity=\"0.1\"/><polygon points=\"388.77 435.96 388.77 449.7 373.08 448.1 373.08 435.96 388.77 435.96\" fill=\"#fff\" opacity=\"0.1\"/><polygon points=\"368.3 440.29 368.3 447.6 352.62 445.99 352.62 440.29 368.3 440.29\" fill=\"#fff\" opacity=\"0.1\"/><path d=\"M510.63,483.7c-10.75,13.75-46.25,4.25-46.25,4.25L438,460.43l-3.58-3.73,7-13s2,.66,5.34,1.82C464.44,451.7,519.68,472.13,510.63,483.7Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M509.63,481.7c-10.75,13.75-46.25,4.25-46.25,4.25L437,458.43l-3.58-3.73,7-13s2,.66,5.34,1.82C463.44,449.7,518.68,470.13,509.63,481.7Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#efb7b9\"/><path d=\"M445.72,443.52c-1.46,4.2-5.17,10.42-8.76,14.91l-3.58-3.73,7-13S442.39,442.36,445.72,443.52Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M358.38,288s-26.25,10-26.5,38a460.08,460.08,0,0,0,3,54s-7.5,41.75,13.75,53.75,41,22,41,22,33.95,5.5,38.12,7.25,18.66-20.75,16.41-24.5-33.16-13-36.83-19.25-12.71-10.46-12.71-10.46-9.22-6.29-9.59-11.54,2.35-9,3.12-11.25,3.56-24.25,3.56-24.25S406.63,283.7,358.38,288Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#dce6f2\"/><path d=\"M370.38,380.7s-35.5,4-32.75,16.5C337.63,397.2,351.12,384.59,370.38,380.7Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M370.38,385.7s-20.15,14.75-16.45,15.75S370.38,385.7,370.38,385.7Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M379.38,391.7s-5.75,10.34-2.5,9.8S379.38,391.7,379.38,391.7Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.1\"/><path d=\"M749,167.42s-38-2.29-33.56,24.37c0,0-.89,4.71,3.38,6.85,0,0,.07-2,3.9-1.31a17.51,17.51,0,0,0,4.13.2,8.57,8.57,0,0,0,5.06-2.09h0s10.69-4.41,14.85-21.89c0,0,3.08-3.82,3-4.8l-6.42,2.75s2.19,4.63.46,8.48c0,0-.2-8.31-1.44-8.12-.25,0-3.33,1.61-3.33,1.61s3.77,8.06.92,13.93c0,0,1.08-9.94-2.1-13.35l-4.52,2.64s4.41,8.33,1.42,15.13c0,0,.77-10.43-2.37-14.49l-4.1,3.19s4.15,8.22,1.62,13.86c0,0-.33-12.14-2.51-13.06,0,0-3.58,3.16-4.12,4.46,0,0,2.83,6,1.07,9.11,0,0-1.08-8.09-2-8.13,0,0-3.57,5.36-3.94,9a19.46,19.46,0,0,1,3.07-9.54,10.71,10.71,0,0,0-5.46,2.83s.55-3.79,6.34-4.12c0,0,3-4.07,3.74-4.32,0,0-5.76-.48-9.25,1.07,0,0,3.07-3.57,10.31-2l4-3.3s-7.58-1-10.8.11c0,0,3.7-3.16,11.89-.86l4.4-2.63s-6.46-1.4-10.31-.89c0,0,4.06-2.19,11.6.18l3.15-1.41s-4.74-.93-6.12-1.08-1.46-.53-1.46-.53a16.36,16.36,0,0,1,8.89,1S749.14,167.84,749,167.42Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\"/><path d=\"M864.46,300.76s-38-2.29-33.56,24.37c0,0-.89,4.71,3.38,6.85,0,0,.07-2,3.91-1.31a17.51,17.51,0,0,0,4.13.2,8.56,8.56,0,0,0,5-2.08h0s10.7-4.42,14.86-21.9c0,0,3.07-3.81,2.95-4.79l-6.42,2.74s2.19,4.63.47,8.48c0,0-.21-8.31-1.44-8.12-.25,0-3.34,1.61-3.34,1.61s3.78,8.07.93,13.93c0,0,1.08-9.94-2.11-13.35L848.75,310s4.41,8.33,1.42,15.13c0,0,.77-10.43-2.37-14.49l-4.09,3.2s4.14,8.21,1.62,13.85c0,0-.33-12.14-2.51-13.06,0,0-3.58,3.16-4.13,4.46,0,0,2.84,6,1.08,9.11,0,0-1.08-8.09-2-8.13,0,0-3.57,5.36-3.94,9a19.52,19.52,0,0,1,3.08-9.54,10.76,10.76,0,0,0-5.47,2.83s.56-3.79,6.35-4.12c0,0,2.95-4.07,3.74-4.32,0,0-5.76-.48-9.25,1.07,0,0,3.07-3.57,10.3-1.95l4-3.3s-7.59-1-10.8.11c0,0,3.7-3.16,11.89-.86l4.4-2.63s-6.47-1.39-10.32-.89c0,0,4.07-2.19,11.61.18l3.15-1.41s-4.74-.93-6.13-1.08-1.46-.53-1.46-.53a16.39,16.39,0,0,1,8.9,1S864.58,301.18,864.46,300.76Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\" opacity=\"0.1\"/><path d=\"M633.61,277.09s8.75-37.09-18.29-37.22c0,0-4.49-1.68-7.32,2.16,0,0,1.93.41.62,4.07a17.8,17.8,0,0,0-.9,4,8.59,8.59,0,0,0,1.19,5.33h0s2.53,11.3,19,18.38c0,0,3.24,3.68,4.22,3.72l-1.6-6.79s-4.94,1.37-8.44-1c0,0,8.23,1.21,8.24,0,0-.25-1-3.56-1-3.56s-8.59,2.34-13.89-1.47c0,0,9.61,2.76,13.52.21L627.16,260s-9,2.93-15.16-1.18c0,0,10.15,2.54,14.69.14l-2.45-4.58s-8.8,2.68-13.93-.77c0,0,12,1.74,13.3-.24,0,0-2.5-4.07-3.69-4.83,0,0-6.36,1.78-9.16-.49,0,0,8.15.31,8.34-.55,0,0-4.67-4.43-8.23-5.43a19.6,19.6,0,0,1,8.89,4.66,10.79,10.79,0,0,0-1.86-5.87s3.64,1.2,3,7c0,0,3.5,3.6,3.61,4.42,0,0,1.45-5.59.52-9.3,0,0,3,3.64.17,10.49l2.56,4.55s2.32-7.3,1.73-10.66c0,0,2.49,4.18-1.18,11.86l1.85,4.79s2.47-6.14,2.63-10c0,0,1.47,4.38-2.16,11.41l.86,3.34s1.72-4.51,2.1-5.85.77-1.35.77-1.35a16.38,16.38,0,0,1-2.49,8.6S633.18,277.14,633.61,277.09Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\" opacity=\"0.1\"/><path d=\"M550.39,289.73s-30.52-22.83-41.43,1.9c0,0-3.33,3.45-.94,7.58,0,0,1.14-1.61,4,1.06a17.51,17.51,0,0,0,3.34,2.44,8.58,8.58,0,0,0,5.37,1h0s11.36,2.19,24.44-10.12c0,0,4.67-1.5,5.11-2.38L543.39,290s-.72,5.07-4.27,7.34c0,0,4.39-7.06,3.25-7.57-.23-.11-3.67-.5-3.67-.5s-1.28,8.82-6.88,12.15c0,0,6.37-7.71,5.58-12.31l-5.23-.28s-.89,9.39-7.13,13.43c0,0,6.37-8.29,6-13.41l-5.18.42s-1.05,9.13-6.26,12.45c0,0,6.39-10.32,5.08-12.28,0,0-4.73.67-5.9,1.45,0,0-.91,6.54-4.11,8.2,0,0,3.55-7.35,2.83-7.86,0,0-5.93,2.51-8.26,5.37a19.53,19.53,0,0,1,7.82-6.28,10.77,10.77,0,0,0-6.12-.64s2.54-2.86,7.56.05c0,0,4.7-1.77,5.5-1.55,0,0-4.55-3.57-8.32-4.19,0,0,4.54-1.3,9.69,4l5.19-.53s-5.77-5-9.08-5.84c0,0,4.83-.61,10.4,5.81l5.12.23s-4.63-4.72-8.12-6.42c0,0,4.59.4,9.59,6.53l3.41.55s-3.45-3.38-4.53-4.26-.93-1.25-.93-1.25a16.43,16.43,0,0,1,6.89,5.72S550.26,290.14,550.39,289.73Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\" opacity=\"0.1\"/><path d=\"M652,77.62s-30.52-22.84-41.43,1.9c0,0-3.33,3.45-.94,7.58,0,0,1.14-1.61,4,1.06a17.79,17.79,0,0,0,3.35,2.43,8.57,8.57,0,0,0,5.37,1h0s11.36,2.19,24.44-10.13c0,0,4.67-1.49,5.1-2.38L645,77.89s-.71,5.07-4.27,7.34c0,0,4.4-7.06,3.26-7.57-.23-.11-3.67-.5-3.67-.5S639,86,633.4,89.31c0,0,6.36-7.71,5.58-12.31l-5.23-.28s-.9,9.39-7.13,13.42c0,0,6.37-8.29,6-13.41l-5.17.42s-1.06,9.14-6.27,12.46c0,0,6.4-10.32,5.09-12.28,0,0-4.73.67-5.9,1.45,0,0-.91,6.54-4.11,8.2,0,0,3.55-7.35,2.83-7.87,0,0-5.93,2.52-8.26,5.38a19.44,19.44,0,0,1,7.82-6.28,10.7,10.7,0,0,0-6.13-.64s2.55-2.86,7.57.05c0,0,4.7-1.78,5.5-1.55,0,0-4.55-3.57-8.32-4.2,0,0,4.53-1.29,9.68,4l5.19-.53s-5.76-5-9.08-5.85c0,0,4.83-.6,10.41,5.82l5.12.22s-4.63-4.72-8.13-6.41c0,0,4.6.4,9.6,6.53l3.4.55S640,72.86,638.92,72s-.93-1.24-.93-1.24a16.4,16.4,0,0,1,6.89,5.72S651.83,78,652,77.62Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\" opacity=\"0.1\"/><path d=\"M768.62,106.55s-12.2-36.11-35.21-21.92c0,0-4.7,1-5.07,5.71,0,0,1.85-.68,2.67,3.12a18,18,0,0,0,1.37,3.91,8.66,8.66,0,0,0,3.84,3.89h0s8.12,8.25,25.88,5.52c0,0,4.69,1.42,5.55.93l-5-4.91s-3.46,3.77-7.68,3.62c0,0,7.63-3.32,7-4.39-.13-.21-2.74-2.48-2.74-2.48s-6.06,6.53-12.56,6.1c0,0,9.61-2.74,11.57-7l-4.14-3.19s-6.06,7.22-13.49,7c0,0,10-3.21,12.53-7.65l-4.5-2.59s-6,6.93-12.22,6.71c0,0,11.12-4.87,11.15-7.23,0,0-4.27-2.13-5.68-2.15,0,0-4.46,4.87-8,4.43,0,0,7.08-4.05,6.78-4.88,0,0-6.3-1.29-9.85-.25a19.49,19.49,0,0,1,10-.75,10.79,10.79,0,0,0-4.69-4s3.72-.91,6.21,4.33c0,0,4.88,1.21,5.4,1.84,0,0-1.72-5.51-4.47-8.17,0,0,4.47,1.51,5.69,8.82l4.58,2.5s-1.89-7.41-4.17-10c0,0,4.33,2.24,5.27,10.69l4.1,3.09s-1.14-6.52-3.06-9.9c0,0,3.56,2.94,4.2,10.83l2.49,2.38s-.92-4.74-1.3-6.08S761,93,761,93a16.49,16.49,0,0,1,2.43,8.62S768.27,106.81,768.62,106.55Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\" opacity=\"0.1\"/><path d=\"M689,108.33S651.1,104.11,654.23,131c0,0-1.13,4.66,3,7,0,0,.17-2,4-1.1a18.4,18.4,0,0,0,4.12.41,8.6,8.6,0,0,0,5.15-1.83h0s10.91-3.87,16-21.12c0,0,3.26-3.65,3.19-4.64l-6.55,2.42s2,4.73,0,8.49c0,0,.21-8.31-1-8.18-.25,0-3.41,1.44-3.41,1.44s3.36,8.25.22,14c0,0,1.58-9.88-1.43-13.44l-4.65,2.4s4,8.55.65,15.19c0,0,1.3-10.38-1.63-14.59l-4.25,3s3.72,8.41.91,13.92c0,0,.29-12.14-1.84-13.17,0,0-3.74,3-4.35,4.24,0,0,2.53,6.1.62,9.15,0,0-.67-8.13-1.55-8.21,0,0-3.84,5.17-4.4,8.82a19.47,19.47,0,0,1,3.56-9.38,10.76,10.76,0,0,0-5.6,2.55s.74-3.75,6.54-3.79c0,0,3.15-3.91,4-4.12,0,0-5.73-.77-9.3.6,0,0,3.25-3.42,10.39-1.43l4.21-3.09S663.22,115,660,116c0,0,3.86-3,11.92-.25l4.53-2.41s-6.39-1.72-10.26-1.41c0,0,4.17-2,11.58.77l3.22-1.25s-4.69-1.17-6.07-1.39-1.43-.6-1.43-.6a16.45,16.45,0,0,1,8.84,1.44S689.07,108.75,689,108.33Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\" opacity=\"0.1\"/><path d=\"M1020.6,402.5s-37.88-4.22-34.75,22.64c0,0-1.13,4.66,3,7,0,0,.17-2,4-1.11a17.3,17.3,0,0,0,4.12.41,8.53,8.53,0,0,0,5.15-1.83h0s10.91-3.87,15.95-21.11c0,0,3.26-3.66,3.19-4.64l-6.55,2.41s2,4.74,0,8.5c0,0,.21-8.32-1-8.18-.25,0-3.41,1.43-3.41,1.43s3.36,8.25.22,14c0,0,1.58-9.87-1.43-13.44l-4.65,2.41s4,8.55.66,15.19c0,0,1.29-10.38-1.64-14.6l-4.25,3s3.72,8.41.91,13.91c0,0,.29-12.14-1.84-13.16,0,0-3.73,3-4.35,4.24,0,0,2.54,6.1.62,9.15,0,0-.67-8.13-1.55-8.21,0,0-3.84,5.17-4.4,8.82a19.47,19.47,0,0,1,3.56-9.38,10.67,10.67,0,0,0-5.6,2.55s.74-3.76,6.54-3.8c0,0,3.16-3.91,4-4.11,0,0-5.73-.78-9.3.59,0,0,3.25-3.41,10.4-1.42l4.2-3.09s-7.52-1.42-10.79-.44c0,0,3.86-3,11.92-.26l4.53-2.4s-6.39-1.72-10.26-1.41c0,0,4.17-2,11.58.77l3.22-1.26s-4.69-1.17-6.07-1.38-1.43-.6-1.43-.6a16.39,16.39,0,0,1,8.84,1.43S1020.7,402.93,1020.6,402.5Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\" opacity=\"0.1\"/><path d=\"M1078.51,437.88s-37.88-4.21-34.75,22.64c0,0-1.12,4.66,3,7,0,0,.17-2,4-1.1a17.65,17.65,0,0,0,4.11.4A8.64,8.64,0,0,0,1060,465h0s10.9-3.87,15.94-21.12c0,0,3.27-3.65,3.19-4.64l-6.55,2.41s2,4.74,0,8.5c0,0,.21-8.31-1-8.18-.25,0-3.41,1.43-3.41,1.43s3.36,8.25.22,14c0,0,1.58-9.87-1.43-13.43l-4.65,2.4s4,8.55.66,15.19c0,0,1.29-10.38-1.64-14.59l-4.25,3s3.72,8.41.92,13.92c0,0,.28-12.15-1.85-13.17,0,0-3.73,3-4.35,4.24,0,0,2.54,6.1.62,9.15,0,0-.67-8.13-1.55-8.21,0,0-3.84,5.17-4.39,8.82a19.52,19.52,0,0,1,3.55-9.38,10.76,10.76,0,0,0-5.6,2.55s.75-3.76,6.55-3.79c0,0,3.15-3.91,4-4.12,0,0-5.73-.77-9.3.6,0,0,3.25-3.42,10.4-1.43l4.2-3.09s-7.52-1.42-10.79-.44c0,0,3.86-3,11.92-.25l4.53-2.41s-6.39-1.72-10.26-1.41c0,0,4.17-2,11.58.77l3.22-1.25s-4.69-1.17-6.06-1.39-1.44-.6-1.44-.6a16.45,16.45,0,0,1,8.84,1.44S1078.61,438.31,1078.51,437.88Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\" opacity=\"0.1\"/><path d=\"M949.94,139.87s-30.52-22.83-41.43,1.9c0,0-3.33,3.45-.94,7.58,0,0,1.14-1.61,4,1.06a17.51,17.51,0,0,0,3.34,2.44,8.59,8.59,0,0,0,5.37,1h0s11.36,2.19,24.45-10.12c0,0,4.66-1.5,5.1-2.38l-6.87-1.24s-.72,5.07-4.27,7.34c0,0,4.39-7.06,3.25-7.57-.23-.11-3.66-.5-3.66-.5s-1.29,8.82-6.89,12.15c0,0,6.37-7.71,5.58-12.31l-5.23-.28s-.89,9.39-7.13,13.43c0,0,6.38-8.29,6-13.41l-5.18.42s-1,9.13-6.26,12.45c0,0,6.4-10.32,5.08-12.28,0,0-4.73.67-5.9,1.45,0,0-.9,6.54-4.1,8.2,0,0,3.54-7.35,2.82-7.86,0,0-5.93,2.51-8.26,5.37a19.53,19.53,0,0,1,7.82-6.28,10.77,10.77,0,0,0-6.12-.64s2.55-2.86,7.57.05c0,0,4.69-1.77,5.49-1.55,0,0-4.55-3.57-8.32-4.19,0,0,4.54-1.3,9.69,4l5.19-.53s-5.76-5-9.08-5.84c0,0,4.83-.61,10.4,5.81l5.13.23s-4.64-4.72-8.13-6.42c0,0,4.6.4,9.59,6.53l3.41.55s-3.45-3.38-4.53-4.26S936,133,936,133a16.44,16.44,0,0,1,6.88,5.72S949.81,140.28,949.94,139.87Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\" opacity=\"0.1\"/><path d=\"M973.52,304.69S963,268.06,939.34,281.21c0,0-4.74.73-5.33,5.47,0,0,1.88-.59,2.53,3.24a17.73,17.73,0,0,0,1.2,4A8.59,8.59,0,0,0,941.4,298h0s7.74,8.6,25.6,6.68c0,0,4.62,1.62,5.5,1.18l-4.73-5.14s-3.63,3.62-7.83,3.28c0,0,7.76-3,7.16-4.07-.12-.22-2.62-2.61-2.62-2.61s-6.34,6.26-12.82,5.53c0,0,9.73-2.3,11.87-6.44l-4-3.38s-6.38,6.94-13.79,6.4c0,0,10.08-2.77,12.86-7.08l-4.38-2.79s-6.35,6.65-12.51,6.15c0,0,11.33-4.37,11.47-6.72,0,0-4.18-2.32-5.59-2.4,0,0-4.67,4.66-8.22,4.06,0,0,7.26-3.73,7-4.57,0,0-6.24-1.57-9.83-.7a19.51,19.51,0,0,1,10-.29,10.73,10.73,0,0,0-4.5-4.2s3.76-.75,6,4.6c0,0,4.81,1.42,5.31,2.08,0,0-1.47-5.59-4.1-8.36,0,0,4.4,1.7,5.29,9.06l4.46,2.71s-1.56-7.5-3.72-10.14c0,0,4.22,2.43,4.79,10.91l4,3.27s-.85-6.56-2.61-10c0,0,3.43,3.1,3.71,11l2.38,2.5s-.7-4.78-1-6.14,0-1.55,0-1.55a16.39,16.39,0,0,1,2.05,8.72S973.16,304.93,973.52,304.69Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\" opacity=\"0.1\"/><path d=\"M739.1,387.23s-20.43-32.18-39.4-12.92c0,0-4.34,2-3.58,6.75,0,0,1.65-1.1,3.35,2.4a17.12,17.12,0,0,0,2.26,3.46,8.54,8.54,0,0,0,4.65,2.88h0s9.85,6.08,26.45-.8c0,0,4.89.26,5.61-.41l-6-3.6s-2.47,4.5-6.6,5.35c0,0,6.62-5,5.73-5.92-.17-.18-3.25-1.76-3.25-1.76s-4.33,7.78-10.75,8.91c0,0,8.69-4.95,9.59-9.53l-4.79-2.11s-4.17,8.45-11.43,10c0,0,8.9-5.49,10.35-10.41l-5-1.44s-4.22,8.17-10.27,9.42c0,0,9.64-7.38,9.11-9.68,0,0-4.66-1.05-6-.73,0,0-3.17,5.79-6.75,6.21,0,0,5.92-5.62,5.43-6.36,0,0-6.43.25-9.63,2.1a19.46,19.46,0,0,1,9.54-3.1,10.73,10.73,0,0,0-5.49-2.77s3.39-1.77,7,2.73c0,0,5,0,5.69.5,0,0-3-5-6.29-6.87,0,0,4.7.4,7.62,7.21l5.05,1.34s-3.61-6.75-6.42-8.68c0,0,4.73,1.14,7.66,9.13l4.72,2s-2.66-6.05-5.33-8.88c0,0,4.16,2,6.65,9.51l3,1.73s-2-4.39-2.71-5.6-.43-1.49-.43-1.49a16.4,16.4,0,0,1,4.41,7.79S738.83,387.57,739.1,387.23Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\" opacity=\"0.1\"/><path d=\"M873.37,222.81s-19.43-32.79-39-14.13c0,0-4.4,1.9-3.78,6.64,0,0,1.67-1.06,3.27,2.49a17.28,17.28,0,0,0,2.15,3.54,8.49,8.49,0,0,0,4.56,3h0s9.65,6.38,26.46,0c0,0,4.88.41,5.62-.24l-5.87-3.78s-2.6,4.41-6.76,5.14c0,0,6.77-4.83,5.92-5.74-.18-.19-3.2-1.87-3.2-1.87s-4.57,7.65-11,8.58c0,0,8.84-4.68,9.87-9.22L856.89,215s-4.43,8.33-11.74,9.66c0,0,9.07-5.21,10.67-10.08l-4.94-1.6s-4.48,8-10.56,9.1c0,0,9.86-7.08,9.4-9.39,0,0-4.62-1.2-6-.92,0,0-3.35,5.69-6.94,6,0,0,6.09-5.42,5.63-6.18,0,0-6.44.05-9.69,1.8a19.52,19.52,0,0,1,9.63-2.8,10.75,10.75,0,0,0-5.41-2.94s3.45-1.67,7,2.94c0,0,5,.17,5.67.68,0,0-2.83-5-6.07-7.06,0,0,4.68.54,7.39,7.44l5,1.5s-3.39-6.86-6.15-8.88c0,0,4.7,1.29,7.38,9.36l4.65,2.17s-2.47-6.13-5-9c0,0,4.09,2.13,6.36,9.71l2.93,1.82s-1.88-4.45-2.54-5.68-.38-1.5-.38-1.5a16.43,16.43,0,0,1,4.17,7.92S873.08,223.14,873.37,222.81Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\"/><path d=\"M750.44,291.76s1-38.1-25.47-32.73c0,0-4.74-.73-6.74,3.61,0,0,2,0,1.44,3.85a17.56,17.56,0,0,0-.06,4.14,8.55,8.55,0,0,0,2.25,5h0s4.77,10.54,22.38,14.12c0,0,3.91,2.95,4.89,2.79l-3-6.32s-4.55,2.34-8.46.75c0,0,8.3-.49,8.07-1.71,0-.25-1.72-3.29-1.72-3.29s-7.94,4.05-13.89,1.39c0,0,10,.75,13.27-2.54l-2.79-4.43s-8.18,4.68-15.08,1.92c0,0,10.45.42,14.41-2.85l-3.33-4s-8.07,4.42-13.79,2.08c0,0,12.12-.73,13-2.94,0,0-3.28-3.47-4.6-4,0,0-5.86,3-9.06,1.38,0,0,8-1.34,8.05-2.23,0,0-5.47-3.39-9.16-3.64a19.47,19.47,0,0,1,9.65,2.76,10.75,10.75,0,0,0-3-5.37s3.81.43,4.33,6.2c0,0,4.17,2.82,4.44,3.6,0,0,.29-5.77-1.38-9.21,0,0,3.68,2.95,2.3,10.23l3.43,3.94s.78-7.62-.47-10.79c0,0,3.28,3.59,1.26,11.85l2.77,4.31s1.18-6.51.55-10.34c0,0,2.32,4,.2,11.61l1.52,3.1s.77-4.77.87-6.16.48-1.48.48-1.48a16.42,16.42,0,0,1-.69,8.93S750,291.89,750.44,291.76Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\"/><ellipse cx=\"698.97\" cy=\"716.3\" rx=\"26.93\" ry=\"4.55\" fill=\"#6c63ff\" opacity=\"0.1\"/><ellipse cx=\"600.8\" cy=\"785.38\" rx=\"26.93\" ry=\"4.55\" fill=\"#6c63ff\" opacity=\"0.1\"/><ellipse cx=\"93.14\" cy=\"749.99\" rx=\"26.93\" ry=\"4.55\" fill=\"#6c63ff\" opacity=\"0.1\"/><ellipse cx=\"805.06\" cy=\"780.83\" rx=\"26.93\" ry=\"4.55\" fill=\"#6c63ff\" opacity=\"0.1\"/><ellipse cx=\"833.1\" cy=\"723.1\" rx=\"40.21\" ry=\"6.8\" fill=\"#6c63ff\"/><path d=\"M945,767a11.61,11.61,0,0,0,3.83-5.78c.5-2.3-.48-5.05-2.67-5.89-2.46-.94-5.09.76-7.09,2.48s-4.27,3.69-6.88,3.33a10.5,10.5,0,0,0,3.24-9.81,4.11,4.11,0,0,0-.9-2c-1.37-1.46-3.84-.83-5.48.32-5.2,3.66-6.65,10.72-6.68,17.08-.52-2.29-.08-4.68-.09-7s-.66-5-2.65-6.22a7.91,7.91,0,0,0-4-1c-2.34-.08-4.95.15-6.54,1.86-2,2.12-1.47,5.69.25,8s4.35,3.8,6.77,5.42a15.13,15.13,0,0,1,4.84,4.61,4.7,4.7,0,0,1,.35.82h14.66A40.44,40.44,0,0,0,945,767Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#6c63ff\"/><path d=\"M170.29,783.87s15.35-.47,20-3.77,23.63-7.23,24.78-1.94,23.08,26.29,5.74,26.43-40.29-2.7-44.91-5.52S170.29,783.87,170.29,783.87Z\" transform=\"translate(-95.23 -55.03)\" fill=\"#a8a8a8\"/><path d=\"M221.1,802.75c-17.34.14-40.29-2.7-44.91-5.52-3.52-2.14-4.92-9.83-5.39-13.38l-.51,0s1,12.39,5.59,15.2,27.57,5.66,44.91,5.52c5,0,6.73-1.82,6.64-4.46C226.73,801.72,224.82,802.72,221.1,802.75Z\" transform=\"translate(-95.23 -55.03)\" opacity=\"0.2\"/></svg>";

/***/ })

}]);
//# sourceMappingURL=photos-src_mixins_FilesSelectionMixin_js-src_components_File_vue-src_components_FilesListViewer_vue.js.map?v=bfe86fb77cd815deb857